% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Empirical_MP.R
\name{Emp}
\alias{Emp}
\title{A flexible empirical management procedure.}
\usage{
Emp(
  x,
  Data,
  reps = 1,
  Inds = NA,
  I_freq = NA,
  I_wt = NA,
  calib_yrs = 2,
  enp_mult = 0.3,
  Ind_fac = NA,
  TACrng = NA,
  delta_down = c(0.01, 0.5),
  delta_up = c(0.01, 0.5),
  resp = 1,
  curI_2_target = NA,
  HCR_CP_B = c(0, 0),
  HCR_CP_TAC = c(0, 1),
  Mode = 1
)
}
\arguments{
\item{x}{Positive integer, the simulation number (a position in data object Data)}

\item{Data}{An object of class 'Data' containing all fishery data (simulated or real - real has only one 'simulation')}

\item{reps}{Positive integer, the number of stochastic samples of management advice (not applicable here)}

\item{Inds}{Vector of positive integers. The indices (dimension 2) of the Additional Indices Data@AddInd to be used in calculation. When this is NA, the single index Data@Ind is used}

\item{I_freq}{Vector of positive integers. Same length as Inds - how frequently will each index be available. 1 is every year, 2 is every 2 years, etc.}

\item{I_wt}{Vector of positive real numbers. Same lengtt as Inds - the weighting of each index in the calculation of mean index level.}

\item{calib_yrs}{Positive integer. The number of recent historical years used to calculate the 'current' Catch per Index value (more or less a nuisance parameter)}

\item{enp_mult}{Fraction. The degree of smoothing for the polynomial function of indices. Larger numbers mean more smoothing. This is effective number of parameters. 0.3 means that the number of parameters in the polynomial smoother is 30\% the length of the index.}

\item{Ind_fac}{Positive real number. The factor (multiplier) of current catch(calib_yrs) / index(calib_yrs) to fish at in the future. A value of 2 means that per index the catches will be twice as high as today. If NA, the fraction of  defaults to perfectly known mean((0.75 * FMSY)/last_historical_F) - mean over simulations.}

\item{TACrng}{Vector 2 positions long, the minimum and maximum allowable catches. If NA this defaults to c(0, max_historical_catch*100) - essentially no TAC limit.}

\item{delta_down}{Vector 2 positions long, the minimum and maximum allowable fractional downward change in TAC among management cycles.}

\item{delta_up}{Vector 2 positions long, the minimum and maximum allowable fractional upward change in TAC among management cycles.}

\item{resp}{Positive real number, the responsiveness of the TAC change algorithm. TAC_change = exp(log(new_TAC/old_TAC)*resp). Lower values linearly reduce the logspace TAC response and make smaller adjustements as proposed TAC changes are larger).}

\item{curI_2_target}{Positive real number, the current (most recent historical year) index relative that at the target biomass level. If NA this defaults to perfectly known mean(last_historical_biomass / (1.25 * BMSY)), mean over all simulations.}

\item{HCR_CP_B}{Vector of positive real numbers. Biomass control points of an HCR. These are the x-axis locations of the hockey stick inflection points. c(0,1) means a linear ramp from I/I_target. c(0.5,1) means no fishing til half I_target then a linear ramp in fishing to I_target. c(0,0) means no HCR.}

\item{HCR_CP_TAC}{Vector of positive real numbers. Response control points of an HCR. These are the y-levels corresponding with the hockey stick. These are the minimum and maximum modifiers applied to the TAC recommendation.}

\item{Mode}{Integer. What type of index-based MP is used? 1 = Index rate, aims to fish at a rate of index (ie TAC = f(I, current_C / current_I, Ind_fac, HCR_CP_B, HCR_CP_TAC)), 2 = Index target, makes incremental TAC adjustments based on I/I_target (i.e. TAC = f(I, curI_2_target, ))}
}
\value{
An object of class \code{MP}.
}
\description{
An all-purpose empirical MP that runs of Indices of relative abundance
}
\author{
T. Carruthers
}
