% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MSCsimtester.R
\name{plotEdgeOrder}
\alias{plotEdgeOrder}
\title{Plot species tree, with edge numbers on edges.}
\usage{
plotEdgeOrder(stree)
}
\arguments{
\item{stree}{An object of class \code{phylo} containing a rooted metric
species tree.}
}
\value{
NONE
}
\description{
Under the MSC, each edge in the species tree must be assigned a population
size.  This function displays the species tree with the edges
numbered, to aid the user in entering constant population sizes as an
appropriately ordered list.
}
\examples{
stree=read.tree(text="(((a:10000,b:10000):10000,c:20000):10000,d:30000);")
plotEdgeOrder(stree)
pops=c(30000,20000,1,1,1,1,10000)
plotPops(stree,pops)

}
\seealso{
\code{\link{pairwiseDist}}, \code{\link{rootedTriple}}, \code{\link{plotPops}}
}
