% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/mrs.R
\name{mrs}
\alias{mrs}
\title{Multi Resolution Scanning}
\usage{
mrs(X, G, n_groups = length(unique(G)), Omega = "default", K = 6,
  init_state = NULL, beta = 1, gamma = 0.3, eta = 0.3, alpha = 0.5,
  return_global_null = TRUE, return_tree = TRUE, min_n_node = 0)
}
\arguments{
\item{X}{Matrix of the data. Each row represents an observation.}

\item{G}{Numeric vector of the group label of each observation. Labels are integers starting from 1.}

\item{n_groups}{Number of groups.}

\item{Omega}{Matrix defining the vertices of the sample space.
The \code{"default"} option defines a hyperrectangle containing all the data points.
Otherwise the user can define a matrix  where each row represents a dimension,
and the two columns contain the associated lower and upper limits for each dimension.}

\item{K}{Depth of the tree. Default is \code{K = 5}, while the maximum is \code{K = 14}.}

\item{init_state}{Initial state of the hidden Markov process.
The three states are \emph{null}, \emph{altenrative} and \emph{prune}, respectively.}

\item{beta}{Spatial clustering parameter of the transition probability matrix. Default is \code{beta = 1}.}

\item{gamma}{Parameter of the transition probability matrix. Default is \code{gamma = 0.3}.}

\item{eta}{Parameter of the transition probability matrix. Default is \code{eta = 0.3}.}

\item{alpha}{Pseudo-counts of the Beta random probability assignments. Default is \code{alpha = 0.5}.}

\item{return_global_null}{Boolean indicating whether to return the posterior probability of the global null hypothesis.}

\item{return_tree}{Boolean indicating whether to return the posterior representative tree.}

\item{min_n_node}{Node in the tree is returned if there are more than \code{min_n_node} data-points in it.}
}
\value{
An \code{mrs} object.
}
\description{
This function executes the Multi Resolution Scanning algorithm to detect differences
across multiple distributions.
}
\examples{
set.seed(1)
n = 20
p = 2
X = matrix(c(runif(p*n/2),rbeta(p*n/2, 1, 4)), nrow=n, byrow=TRUE)
G = c(rep(1,n/2), rep(2,n/2))
ans = mrs(X=X, G=G)
}

