% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.r
\docType{data}
\name{npf}
\alias{npf}
\title{npf fishery catch data from Northern Prawn Fishery 1970-1992}
\format{
A data.frame of fisheries data
\describe{
  \item{year}{the fishing year from 1970 - 1992.}
  \item{banana}{banana prawn catches, tonnes.}
  \item{tiger}{tiger prawn catches, tonnes.}
  \item{endevaour}{endeavour prawn catches, tonnes.}
  \item{king}{king prawn catches, tonnes.}
  \item{boats}{the number of vessels fishing in that year.}
  \item{boatday}{the total annual effort as boatdays.}
}
}
\source{
Robins, C. and I. Somers (1994) Appendix A. Fishery 
    Statistics pp 141 - 164 in Pownall, P.C. (ed.) Australia's 
    Northern Prawn Fishery: The first 25 years. NPF25. Cleveland, 
    Australia. 179p.
}
\description{
npf is fishery catch data from Australia's Northern 
    Prawn Fishery from 1970 to 1992 summarized from Robins and
    Somers, 1994. It contains the catches, in tonnes, 
    of banana prawns (\emph{Penaeus merguiensis} and \emph{P. indicus}), 
    tiger prawns (brown - \emph{P. esculentus}) and (grooved - \emph{P. 
    semisulcatus}), endeavour prawns, (\emph{Metapenaeus endeavouri} and 
    \emph{M. ensis}), king prawns (\emph{P. latisulcatus} and 
    \emph{P. longistylus}), the number of vessels fishing, and 
    the annual effort as boat-days.
}
\section{Subjects}{

 \itemize{
   \item correlation analysis and regression
   \item Bootstrap percentile confidence intervals
   \item Model residuals
 }
}

\examples{
 data(npf)
 npf
 oldpar <- par(no.readonly=TRUE)
 plot1(npf$year,npf$tiger,xlab="Year",ylab="Tonnes",lwd=2)
 lines(npf$year,npf$endeavour,col=2,lwd=2)
 legend("topleft",c("Tiger","Endeavour"),col=c(1,2),lwd=3,
        bty="n",cex=1.5)
 par(oldpar)
}
