% Generated by roxygen2 (4.0.2): do not edit by hand
\name{callingProcess}
\alias{callingProcess}
\title{Calling aberrations in segmented copy-number signal.}
\usage{
callingProcess(segmentData, nclass = 5, cellularity = 1, verbose = TRUE,
  ...)
}
\arguments{
\item{segmentData}{A list (see details).}

\item{nclass}{The number of levels to be used for calling. Either 3 (loss, normal, gain), 4 (including amplifications), 5 (including double deletions).}

\item{cellularity}{Proportion of tumor cells in the sample ranging from 0 to 1 (default=1). Reflects the contamination of the sample with healthy cells (1 = no contamination).}

\item{verbose}{If TRUE, print some details.}

\item{...}{other options of CGHcall functions}
}
\value{
A list with the same element as segmentData list and
\describe{
  \item{calls}{A matrix, of the same size as segmentData$copynumber matrix, containing the label of each point.
  -2=double loss, -1=loss, 0=normal, 1=gain, 2=amplification.}
  \item{segment}{A data.frame that summarizes the different segments found.}
  \item{probdloss}{(if CGHcall was run with nclass=5) A matrix of the same size as segmentData$copynumber matrix. It contains the probability for each segmented copynumber to be a double loss.}
  \item{probloss}{A matrix of the same size as segmentData$copynumber matrix. It contains the probability for each segment to be a loss.}
  \item{probdnorm}{A matrix of the same size as segmentData$copynumber matrix. It contains the probability for each segment to be normal.}
  \item{probdgain}{A matrix of the same size as segmentData$copynumber matrix. It contains the probability for each segment to be a gain.}
  \item{probdamp}{(if CGHcall was run with nclass=4 or 5) A matrix of the same size as segmentData$copynumber matrix. It contains the probability for each segment to be an amplification.}
}
}
\description{
Launch the process of segmentation labeling. This function uses functions from CGHcall package developped by Sjoerd Vosse, Mark van de Wiel and Ilari Scheinin. See the CGHcall package for more details.
}
\details{
segmentData is a list containing:
 \describe{
  \item{copynumber}{A matrix. Each column contains a signal of copynumber for a profile. Each row corresponds to a genomic position of a probe.}
  \item{segmented}{A matrix of the same size as copynumber. It contains the segmented signals.}
  \item{chromosome}{A vector of length nrow(copynumber) containing the studied chromosome (number) for each position.}
  \item{startPos}{A vector of length nrow(copynumber) containing the starting genomic position of each probe.}
  \item{featureNames}{A vector of length nrow(copynumber) containing the names of each probe.}
  \item{sampleNames}{A vector of length ncol(copynumber) containing the names of each profile.}
}
}
\author{
Quentin Grimonprez
}

