% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MODIStsp_process_indexes.R
\name{MODIStsp_process_indexes}
\alias{MODIStsp_process_indexes}
\title{MODIStsp_process_indexes}
\usage{
MODIStsp_process_indexes(out_filename, formula, bandnames, nodata_out,
  out_prod_folder, indexes_nodata_out, file_prefix, yy, DOY, out_format,
  scale_val)
}
\arguments{
\item{out_filename}{basename of the file in to which save results}

\item{formula}{string Index formula, as derived from XML file and stored in prod_opts
within previous_file}

\item{bandnames}{string array of names of original HDF layer. Used to identify the
bands required for index computation}

\item{nodata_out}{string array of nodata values of reflectance bands}

\item{out_prod_folder}{strng output folder for the product used to retrieve filenames
of rasters of original bands to be used in computations}

\item{indexes_nodata_out}{string nodata value for resulting raster}

\item{file_prefix}{string used to retrieve filenames of rasters of original bands
to be used in computations}

\item{yy}{string string used to retrieve filenames of rasters of original bands
to be used in computations}

\item{DOY}{string used to retrieve filenames of rasters of original bands to be
used in computations}

\item{out_format}{string used to retrieve filenames of rasters of original bands
to be used in computations}

\item{scale_val}{string (Yes/No) if Yes, output values in are computed as float -1 - 1,
otherwise integer -10000 - 10000}
}
\value{
NULL - new raster file saved in out_filename
}
\description{
function used to compute spectral indexes, given the index formula
}
\details{
the function parses the index formula to identify the required bands. On the basis
of identified bands, it retrieves the reflectance bands required, gets the data into R raster
objects, performs the computation and stores results in a GeoTiff or ENVI raster file
}
\note{
License: GPL 3.0
}
\author{
Lorenzo Busetto, phD (2014-2015) \email{busetto.l@irea.cnr.it}

Luigi Ranghetti, phD (2015) \email{ranghetti.l@irea.cnr.it}
}
