% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/arcStats.R
\name{arcStats}
\alias{arcStats}
\title{Get Summary of Local MODIS Data}
\usage{
arcStats(
  product,
  collection = NULL,
  extent = "global",
  begin = "2000.01.01",
  end = format(Sys.time(), "\%Y.\%m.\%d"),
  asMap = TRUE,
  outName = NULL,
  ...
)
}
\arguments{
\item{product}{\code{character}, see \code{\link{getProduct}}. MODIS grid 
product to be checked.}

\item{collection}{\code{character} or \code{integer}, see 
\code{\link{getCollection}}. MODIS product version.}

\item{extent}{Extent information, defaults to \code{'global'}. See
\code{\link{getTile}}.}

\item{begin}{\code{character}. Begin date of MODIS time series, see 
\code{\link{transDate}}.}

\item{end}{\code{character}. End date, defaults to \code{'Today'} expressed in 
a function.}

\item{asMap}{Controls output type. Possible options are \code{TRUE} (png), 
\code{FALSE} (csv) or \code{'both'}.}

\item{outName}{\code{character}. Name of output file, defaults to 
'product.collection.YYYYMMDDHHMMSS.png' (or *.csv) of the function call or, 
if applicable, 'product.collection.extent.YYYYMMDDHHMMSS.png' (or *.csv).}

\item{...}{Arguments passed to \code{\link{MODISoptions}}, most importantly 
\code{outProj} and \code{outDirPath}.}
}
\value{
An invisible \code{NULL} (provably this will change to a matrix-like object 
similar to the '*.csv' output). If \code{asMap= TRUE}, a 'table.csv' and a 
'image.png' file(s) in \code{outDirPath}.
}
\description{
In the same manner as \code{\link{getHdf}}, this function quantifies the 
availability of local MODIS hdf data and gives you an overview (plot or/and 
table) of locally available MODIS grid hdf files.
}
\examples{
\dontrun{
# The following examples are expecting that you have some data stored locally!
########################################################### 
# generates 2 png's and 2 csv's one for TERRA one for AQUA
arcStats(product="M.D13Q1")

# generates 2 png's and 2 csv's one for TERRA one for AQUA with the specified countries.
arcStats(product="M.D13Q1",extent=c("austria","germany","italy"))

# generates 1 png and 1 csv for AQUA.
arcStats(product="MYD13Q1",begin="2005001",outName="MyDataStart2005")

# generates 1 png for AQUA for the selected area and plots it in 'Sinusoidal'.
arcStats(product="MYD13Q1",begin="2005001",asMap=TRUE, outName="InteractiveSelection2005",
         extent=getTile(), outProj="asIn")

# generates 1 png for AQUA for the selected area and plots it in 'Geographic' Coordinates.
arcStats(product="MYD13Q1",begin="2005001",asMap=TRUE, outName="InteractiveSelection2005",
         extent=getTile(), outProj="GEOGRAPHIC")
}

}
\author{
Matteo Mattiuzzi
}
