% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.ZIGP.R
\name{summary.ZIGP}
\alias{summary.ZIGP}
\title{Summary of parameter estimates of a Type I multivariate ZIGP model}
\usage{
\method{summary}{ZIGP}(object, digits = 4, ...)
}
\arguments{
\item{object}{Output from a call to ZIGP.}

\item{digits}{The desired number of digits after the decimal point. Default of 4 digits is used.}

\item{...}{Additional arguments}
}
\value{
Summary for \code{ZIGPMM} objects.
}
\description{
This function returns the result of the \code{ZIGPMM} function
}
\examples{


x1 <- c(0, 0, 0,38, 0,19,25, 0,25, 0)
x2 <- c(0, 0, 0,23, 0,51,24, 0,10, 0)
y <- cbind(x1, x2)
phi0 = 0.5; la = rep(1,2); th = rep(0.1,2)
result <- ZIGPMM(y, phi0, la, th)

summary(result,digits=4)



}
\seealso{
\code{\link{ZIGPMM}}
}
\keyword{methods}
