% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GaFrailtyMM.R
\name{GaFrailtyMM}
\alias{GaFrailtyMM}
\title{MM algorithm based on AD technology for gamma frailty model}
\usage{
GaFrailtyMM(
  formula,
  data,
  beta = NULL,
  theta = NULL,
  lambda = NULL,
  Maxiter = 2000,
  convergence = 1e-06,
  ...
)
}
\arguments{
\item{formula}{A formula object, which contains on the left hand side an object of the type \code{Surv}
and on the right hand side a \code{+cluster(id)} statement.
e.g. \code{formula=Surv(time, status) ~ x + cluster(id)}}

\item{data}{A \code{data.frame} in which to interpret the variables named in the formula.}

\item{beta}{A vector of unknown regression parameters, default is \code{NULL}.
If is \code{NULL}, then make all \code{beta=1} during calculation.}

\item{theta}{The variance of frailty factors subject to gamma distribution, default is \code{NULL}.
If is \code{NULL}, then let \code{theta=1} during calculation.}

\item{lambda}{Baseline hazard rate, default set to \code{NULL}. If is \code{NULL},
then let each \code{lambda} equals to \code{1/N} during calculation, which \code{N} is the number of observed.}

\item{Maxiter}{The maximum number of iterations is specified by default as 2000.}

\item{convergence}{Specify the convergence criterion, the default is 1e-6.}

\item{...}{Additional arguments}
}
\value{
An object of class \code{GaFrailtyMM} that contains the following fields: total amount of observations,
the Time, the \eqn{\Lambda}, the \eqn{\lambda}, total number of failure events, total number of iterations, convergence result, the log likelihood value,
the \eqn{\theta}, the standard deviation of the estimated \eqn{\theta},
the likelihood-based 95\% confidence interval for the \eqn{\theta}, \eqn{\beta},
the standard deviation of the estimated \eqn{\beta}, the likelihood-based 95\% confidence interval for the \eqn{\beta},
the variable name.
}
\description{
Let \eqn{T_{ij}, C_{ij}} and \eqn{X_{ij} = (X_{ij1},\cdots, X_{ijq})^T} denote the
survival time, the censoring time and a vector of covariates, respectively. For the \eqn{j}-th individual in the \eqn{i}-th cluster, for \eqn{j=1, \cdots, M_i } and  \eqn{i=1, \cdots, B}. And assume the censoring time
\eqn{C_{ij}} is independent of the survival time \eqn{T_{ij}} given \eqn{X_{ij}}, and \eqn{I_{ij} = I(T_{ij} \leqslant C_{ij})} is the censoring indicator.
Conditional on a cluster-specific frailty  \eqn{\omega_i},  then the frailty model postulates that the instantaneous hazard rate function of \eqn{T_{ij}} is

\deqn{\lambda(t|X_{ij} , \omega_i )=\lambda_{0}(t) \exp(X_{ij}^{T} \beta) \omega_i}

where \eqn{\lambda_{0}(t)} is a baseline hazard rate and \eqn{\beta} is a vector of regression parameters. We assume that the frailty \eqn{\omega} has a gamma distribution
with mean 1, variance \eqn{\theta} and density

\deqn{ g(\omega) = \frac{\omega^{\frac{1}{1-\theta}} \exp(-\frac{\omega}{\theta})}{\Gamma( \frac{1}{\theta}) \theta^{\frac{1}{\theta}}} }

and we denote \eqn{\Lambda} as the accumulative hazard rate. The \code{GaFrailtyMM} function is used to calculate the gamma frailty model.
}
\details{
The \code{GaFrailtyMM} function is used to calculate gamma frailty survival model using MM algorithms
based on AD technology. EM algorithms relies on the fact that, after profiling out the nonparametric component \eqn{\Lambda_0},
the resulting function is concave. When it does not hold, using Newton method to maximize the resulting function is
difficult especially when there exist a large number of covariates. MM algorithms that can avoid the
concavity requirement and bypass Newton method and matrix inversion.
}
\examples{
library(survival)
GaFrailtyMM(Surv(time, status) ~ age + sex + cluster(id), data=kidney)

}
\references{
Huang X.F., Xu J.F. and Tian G.L.(2019). 'On profile MM algorithms for gamma frailty survival models.' \emph{Statistica Sinica} \strong{29}(2), 895-916.
}
