% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting_utils.R
\name{plot_shap}
\alias{plot_shap}
\title{Plotting SHAP Plots}
\usage{
plot_shap(analysis_object, show_table = FALSE)
}
\arguments{
\item{analysis_object}{Fitted analysis_object with 'sensitivity_analysis(methods = "SHAP")'.}

\item{show_table}{Boolean. Whether to print SHAP summarized results table.}
}
\value{
analysis_object
}
\description{
The \strong{plot_shap()} function implements a comprehensive set of visualizations for SHAP values, including bar
plots of mean absolute values, directional plots showing positive or negative contribution nature, box plots
illustrating SHAP value distributions by variable, and swarm plots combining individual and distributional
information. This multifaceted approach enables deep understanding of how each feature influences model
predictions.
}
\examples{
# Note: For obtaining the SHAP plots the user needs to complete till sensitivity_analysis( )
# function of the MLwrap pipeline using the SHAP method.

\dontrun{

wrap_object <- preprocessing(df = sim_data,
                             formula = psych_well ~ depression + emot_intel + resilience,
                             task = "regression")
wrap_object <- build_model(wrap_object, "Random Forest")
wrap_object <- fine_tuning(wrap_object, "Grid Search CV")
wrap_object <- sensitivity_analysis(wrap_object, methods = "SHAP")

# And then, you can obtain the SHAP plots.

plot_shap(wrap_object)

}

}
