% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting_utils.R
\name{plot_lift_curve}
\alias{plot_lift_curve}
\title{Plotting Lift Curve}
\usage{
plot_lift_curve(analysis_object)
}
\arguments{
\item{analysis_object}{Fitted analysis_object with 'fine_tuning()'.}
}
\value{
analysis_object
}
\description{
The \strong{plot_lift_curve()} function produces lift curves that display the lift factor as a function of population
percentile. This visualization is particularly useful for direct marketing applications, showing how much
better the model performs compared to random selection at different population segments.
}
\examples{
# Note: For obtaining the lift curve plot the user needs to complete till fine_tuning( ) function
# of the MLwrap pipeline and only with categorical outcome.

\dontrun{

wrap_object <- preprocessing(df = sim_data,
                             formula = psych_well_bin ~ depression + emot_intel + resilience,
                             task = "classification")
wrap_object <- build_model(wrap_object, "Random Forest")
wrap_object <- fine_tuning(wrap_object, "Grid Search CV")

# And then, you can obtain the lift curve plot.

plot_lift_curve(wrap_object)

}

}
