% Generated by roxygen2 (4.0.2): do not edit by hand
\name{estimate}
\alias{estimate}
\title{Estimate parameters}
\usage{
estimate(mfit)
}
\arguments{
\item{mfit}{- a MInt model object.}
}
\value{
A MInt model object with the following attributes:
 \item{optim}{List containing optimization details}
 \item{optim$lambda}{Value of the L1 penalty used during optimization}
 \item{data}{List containing the raw data}
 \item{data$design}{File path of the design matrix}
 \item{data$response}{File path of the response matrix}
 \item{data$fmla}{Formula used to model each response in terms of the design variables}
 \item{data$y}{Raw numerical data for the response matrix}
 \item{data$xd}{Design matrix in categorical form}
 \item{data$x}{Design matrix in numerical form}
 \item{param}{List containing parameter estimates}
 \item{param$beta}{p-covariates x o-responses matrix of regression coefficients}
 \item{param$w}{n-samples x o-responses matrix of latent abundances}
 \item{param$P}{o-responses x o-responses precision matrix}
}
\description{
This function performs iterative conditional modes to obtain
maximum \emph{a posteriori} estimates for \eqn{\beta} (covariate coefficients),
\eqn{w} (latent abundances), and \eqn{P} (the precision matrix).
}
\examples{
x <- system.file("extdata", "x.txt", package="MInt");
y <- system.file("extdata", "y.txt", package="MInt");
m <- mint(y,x,fmla = ~feature1 + feature2)
m <- estimate(m)
}

