% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper.R
\name{parse_epoch_string}
\alias{parse_epoch_string}
\title{Parse epoch string to the corresponding number of samples it represents.}
\usage{
parse_epoch_string(epoch_str, sr)
}
\arguments{
\item{epoch_str}{string. The input epoch str as accepted by \code{breaks}
argument of \code{\link[base]{cut.POSIXt}}.}

\item{sr}{number. The sampling rate in Hz used to parse the epoch string.}
}
\value{
number. The number of samples represented by the epoch string.
}
\description{
\code{parse_epoch_string} parses the epoch string (e.g. "1 min"), and outputs
the corresponding number of samples it represents.
}
\details{
This function parses the given epoch string (e.g. "5 secs") and outputs the
corresponding number of samples represented by the epoch string.
}
\section{How is it used in MIMS-unit algorithm?}{
 This function is used in
  \code{\link{aggregate_for_mims}} function and \code{\link{mims_unit}} function.
}

\examples{
# 1 min with 80 Hz = 4800 samples
parse_epoch_string('1 min', sr=80)

# 30 sec with 30 Hz = 900 samples
parse_epoch_string('30 sec', sr=30)

# 1 hour with 1 Hz = 3600 samples
parse_epoch_string('1 hour', sr=1)

# 1 day with 10 Hz = 864000 samples
parse_epoch_string('1 day', sr=10)
}
\seealso{
Other utility functions: 
\code{\link{clip_data}()},
\code{\link{cut_off_signal}()},
\code{\link{interpolate_signal}()},
\code{\link{sampling_rate}()},
\code{\link{segment_data}()},
\code{\link{simulate_new_data}()}
}
\concept{utility functions}
