% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GetHpltTable_func_20200915.R
\name{GetHpltTable}
\alias{GetHpltTable}
\title{GetHpltTable() function}
\usage{
GetHpltTable(filepath)
}
\arguments{
\item{filepath}{is a user defined path to the folder where the output files
from the HpltFind() function have been saved.}
}
\value{
A table with the mean proportion of incongruent sequences for each
  nest.
}
\description{
\code{\link{GetHpltTable}} uses the output files produced by the HpltFind()
function to produce a table with the mean proportion of incongruent sequences
for each nest. If the mean proportion of incongruent sequences is generally
low, but certain nests have many incongruent sequences, biological reasons
may be causing the mismatches, e.g. extra-pair fertilizations or
recombination events.
}
\details{
If you publish data or results produced with MHCtools, please cite both of
the following references:
Roved, J. (2022). MHCtools: Analysis of MHC data in non-model species. Cran.
Roved, J. (2024). MHCtools 1.5: Analysis of MHC sequencing data in R. In S.
Boegel (Ed.), HLA Typing: Methods and Protocols (2nd ed., pp. 275–295).
Humana Press. https://doi.org/https://doi.org/10.1007/978-1-0716-3874-3_18
}
\examples{
filepath <- system.file("extdata/HpltFindOut/", package="MHCtools")
GetHpltTable(filepath)
}
\seealso{
\code{\link{HpltFind}}; \code{\link{GetHpltStats}}
}
