% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Cube-Wolbachia.R
\name{cubeWolbachia}
\alias{cubeWolbachia}
\title{Inheritance Cube: Wolbachia}
\usage{
cubeWolbachia(eta = NULL, phi = NULL, omega = NULL, xiF = NULL,
  xiM = NULL, s = NULL)
}
\arguments{
\item{eta}{Genotype-specific mating fitness}

\item{phi}{Genotype-specific sex ratio at emergence}

\item{omega}{Genotype-specific multiplicative modifier of adult mortality}

\item{xiF}{Genotype-specific female pupatory success}

\item{xiM}{Genotype-specific male pupatory success}

\item{s}{Genotype-specific fractional reduction(increase) in fertility}
}
\value{
Named list containing the inheritance cube, transition matrix, genotypes, wild-type allele,
and all genotype-specific parameters.
}
\description{
This function creates an inheritance cube to model a Wolbachia infection. Wolbachia
is a parasite that can infect mosquitoes. It biases its inheritance through
cytoplasmic incompatibility. \cr
This drive has 2 alleles at 1 locus:
\itemize{
\item W: has Wolbachia
\item w: does not have Wolbachia
}
}
\details{
Cytoplasmic Incompatibility:
\itemize{
\item male W cross female w -> all offspring die (complete penetrance)
\item male w cross female W -> all offspring inherit Wolbachia
}
}
