% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SIRS.R
\name{SIRS}
\alias{SIRS}
\title{Model-Free Feature Screening for Ultrahigh Dimensional Data}
\usage{
SIRS(X, Y, nsis = (dim(X)[1])/log(dim(X)[1]))
}
\arguments{
\item{X}{The design matrix of dimensions n * p. Each row is an observation vector.}

\item{Y}{The response vector of dimension n * 1.}

\item{nsis}{Number of predictors recruited by SIRS. The default is n/log(n).}
}
\value{
the labels of first nsis largest active set of all predictors
}
\description{
A novel feature screening procedure under a unified model framework,
which covers a wide variety of commonly used parametric and semi-parametric models.
This method does not require imposing a specific model structure on regression functions,
and thus is particularly appealing to ultrahigh-dimensional regressions, where there are a
huge number of candidate predictors but little information about the actual model forms.
}
\examples{

n=100;
p=200;
rho=0.5;
data=GendataLM(n,p,rho,error="gaussian")
data=cbind(data[[1]],data[[2]])
colnames(data)[1:ncol(data)]=c(paste0("X",1:(ncol(data)-1)),"Y")
data=as.matrix(data)
X=data[,1:(ncol(data)-1)];
Y=data[,ncol(data)];
A=SIRS(X,Y,n/log(n));A

}
\references{
Zhu, L.-P., L. Li, R. Li, and L.-X. Zhu (2011). Model-free feature screening for ultrahigh-dimensional data. Journal of the American Statistical Association 106(496), 1464–1475.
}
\author{
Xuewei Cheng \email{xwcheng@csu.edu.cn}
}
