% (C) 2016 Christian Margreitter
% last update: 2017-02-21
\name{noe}
\alias{noe}
\title{Plot NOE violations}
\description{This function plots Nuclear-Overhauser-Effect (NOE) violations. Note, that negative violations are not considered, in case they are part of the input.}
\usage{
noe( noeData,
     printPercentages = TRUE,
     colours = NA,
     lineTypes = NA,
     names = NA,
     plotSumCurves = TRUE,
     maxYAxis = NA,
     printLegend = FALSE,
     ... )
}
\arguments{
  \item{noeData}{Input matrix. Can be generated by using function \code{\link{load_noe}()}.}
  \item{printPercentages}{If \code{TRUE}, the violations will be reported in a relative manner (percent) instead absolute numbers.}
  \item{colours}{Vector of colours to be used for the bars.}
  \item{lineTypes}{If \code{plotSumCurves} is \code{TRUE}, this vector might be used to specify the types of curves plotted.}
  \item{names}{Vector to name the input columns (legend).}
  \item{plotSumCurves}{If \code{TRUE}, the violations are summed up from left to right to show the overall behaviour.}
  \item{maxYAxis}{Can be used to manually set the y-axis of the plot.}
  \item{printLegend}{Boolean, which triggers plotting of the legend.}
  \item{...}{Additional arguments (ellipsis).}
}
\value{
Returns a matrix, in which the first column holds the bin boundaries used and the following columns represent either the percentage or absolute numbers of the violations per bin, depending on the specification.
}
\examples{
# GROMOS
noe( load_noe( c( system.file( "extdata/noe_example_1.txt.gz",
                               package = "MDplot" ),
                  system.file( "extdata/noe_example_2.txt.gz",
                               package = "MDplot" ) ) ),
     names = c( "run1", "run2" ), printLegend = TRUE )
}
\author{Christian Margreitter}
\keyword{hbond}
\keyword{hydrogen bond}
