% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Theadwaysperformance.R
\name{Theadwaysperformance}
\alias{Theadwaysperformance}
\title{Function to return performance data based on headways surrounding a given
passenger's arrival time at a station on a given route.}
\usage{
Theadwaysperformance(enter_time, exit_time = NULL, enter_route_name,
  exit_route_name, enter_stop_name, exit_stop_name, data, api_key)
}
\arguments{
\item{enter_time}{Entrance time of passenger at station}

\item{exit_time}{End of window in which to look for train arrivals.}

\item{enter_route_name}{Route name for which headways should be returned.}

\item{exit_route_name}{Route name of exit stop for which headways should be
returned.}

\item{enter_stop_name}{Stop name (alpha, non-numeric) designating which
station at which train headways information should be returned.}

\item{exit_stop_name}{Stop name (alpha, non-numeric) designating towards
which station train headways information should be returned.}

\item{data}{Dataframe with named variables given by other arguments.}

\item{api_key}{API key for MBTA Performance API. To obtain one, visit the
MBTA Developer Portal (\url{https://mbta.com/developers/mbta-performance/})}
}
\value{
\item{headway_mean}{Average headway during the time period given
between `enter_time` and `exit_time`.} \item{headway_bench}{Average of
benchmark headways during time period given between `enter_time` and
`exit_time`.} \item{headway_perf}{Average delay (actual headway - benchmark
headway) during the time period given between `enter_time` and `exit_time`.}
\item{next_train}{Arrival time of next train at given station that is after
the entrance time given with `enter_time`.} \item{prev_train}{Arrival time of
previous train to be at station on given route immediately prior to the
entrance time given with `enter_time`.} \item{headway_guess}{Difference (in
seconds) between arrival time of next train and entrance time given with
`enter_time`.} \item{headway_bench_guess}{Benchmark headway time for the
train arriving next after passenger's arrival. Divide by two to find
benchmark wait time.}
}
\description{
Function to return performance data based on headways surrounding a given
passenger's arrival time at a station on a given route.
}
