% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write.functions.R
\name{get.prior}
\alias{get.prior}
\title{Get current priors from JAGS model code}
\usage{
get.prior(model)
}
\arguments{
\item{model}{A character object of JAGS MBNMA model code}
}
\value{
A character vector, each element of which is a line of JAGS code
corresponding to a prior in the JAGS code.
}
\description{
Identical to \code{get.prior()} in MBNMAdose.
This function takes JAGS model presented as a string and identifies what
prior values have been used for calculation.
}
\details{
Even if an MBNMA model that has not initialised successfully and
results have not been calculated, the JAGS model for it is saved in
\code{MBNMA$model.arg$jagscode} and therefore priors can still be obtained.
This allows for priors to be changed even in failing models, which may help
solve issues with initialisation.
}
\examples{
\donttest{
# Create mb.network object using an MBNMAtime dataset
network <- mb.network(osteopain)

# Create mb.network object using an MBNMAdose dataset

# Run linear MBNMA
result <- mb.linear(network,
  slope=list(pool="rel", method="random"))

# Obtain model prior values
get.prior(result$model.arg$jagscode)

# ...also equivalent to
print(result$model.arg$priors)
}

}
