% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/which_lt.R
\name{which_tri}
\alias{which_tri}
\title{Which in lower/upper triangle}
\usage{
which_tri(cond, diag = FALSE, lower = TRUE)
}
\arguments{
\item{cond}{logical vector of length that of the lower triangle}

\item{diag}{logical: are the diagonal entries included?}

\item{lower}{logical: is this the lower triangle?  If FALSE it is the upper.}
}
\value{
a two column matrix with the row and column indices as the rows
}
\description{
Find where the original positions of components are
in a matrix given a logical vector corresponding
to the lower or upper triangle stored by columns.  Similar
to which(.., arr.ind = TRUE)
}
\examples{
set.seed(123)
X <- matrix(rnorm(20*2), 20, 2)
plot(X, asp = 1, pch = 16, las = 1, xlab = "x", ylab = "y")
dX <- dist(X)
ij <- which_tri(dX == max(dX))
points(X[as.vector(ij), ], col = "red", cex = 2, pch = 1)
segments(X[ij[1], 1], X[ij[1], 2],
         X[ij[2], 1], X[ij[2], 2], col = "red")
ij <- which_tri(dX == sort(dX, decreasing = TRUE)[2])
points(X[as.vector(ij), ], col = "blue", cex = 2, pch = 1)
segments(X[ij[1], 1], X[ij[1], 2],
         X[ij[2], 1], X[ij[2], 2], col = "blue")
polygon(X[chull(X), ], border = "sky blue")
rm(X, dX, ij)
}
