% Generated by roxygen2: do not edit by hand
% Please edit documentation in
%   R/Script_PLATE_03_PREPROCESS_3_4_CheckAlignment_SJ.R
\name{CheckAlignment.SJ}
\alias{CheckAlignment.SJ}
\title{Check Alignment for splice junction data}
\usage{
CheckAlignment.SJ(MarvelObject)
}
\arguments{
\item{MarvelObject}{S3 object generated from \code{CreateMarvelObject} or \code{SubsetSamples} function.}
}
\value{
An object of class S3. The original \code{MarvelObject$SplicePheno}, and \code{MarvelObject$PSI} are updated. \code{MarvelObject$IntronCounts} updated if intron coverage matrix detected.
}
\description{
\code{CheckAlignment} checks if the metadata aligns with the columns and rows of the matrix for splice junction data.
}
\details{
This function checks if the \code{sample.id} column of \code{MarvelObject$SplicePheno} aligns with the column names of splice junction count matrix in \code{MarvelObject$SpliceJunction}. To do this, the function subset overlapping sample IDs present in both the phenoData and matrix. If the intron coverage matrix is found in \code{MarvelObject$IntronCounts}, additional checking will be done to check if the \code{sample.id} column of \code{MarvelObject$SplicePheno} and column ames of the splice junction count matrix in \code{MarvelObject$SpliceJunction} align with the column names of intron coverage matrix.
}
\examples{
# Load input
marvel <- readRDS(system.file("extdata/Data", "MarvelObject.rds", package="MARVEL"))

# Run example
marvel <- CheckAlignment.SJ(MarvelObject=marvel)
}
\author{
Sean Wen <sean.wenwx@gmail.com>
}
