% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/confint_MANOVA.R
\name{conf.reg}
\alias{conf.reg}
\title{The conf.reg() function calculates confidence regions for contrasts in multivariate factorial designs.
In the two-dimensional case, confidence ellipsoids can be plotted via the generic \code{plot()} function.}
\usage{
conf.reg(object, nullhypo)
}
\arguments{
\item{object}{A \code{MANOVA} object.}

\item{nullhypo}{In scenarios with more than one factor, the null hypothesis, i.e., 
the contrast of interest must be specified.}
}
\value{
A \code{confreg} object containing the following components: 
  \item{center}{The center of the confidence ellipsoid.}
  \item{scale}{The scaling factors for the axis of the confidence ellipsoid calculated as \eqn{\sqrt{\lambda*c/N}}, where \eqn{\lambda} are the
  eigenvalues, c denotes the bootstrap quantile and N is the total sample size. See Friedrich and Pauly (2018) for details.}
  \item{eigenvectors}{The corresponding eigenvectors, which determine the axes of the ellipsoid.}
}
\description{
The conf.reg() function calculates confidence regions for contrasts in multivariate factorial designs.
In the two-dimensional case, confidence ellipsoids can be plotted via the generic \code{plot()} function.
}
\examples{
data(EEG)
EEG_mod <- MANOVA(resp ~ sex * diagnosis, 
                    data = EEG, subject = "id", resampling = "paramBS", 
                    alpha = 0.05, iter = 100, CPU = 1)
conf.reg(EEG_mod, nullhypo = "sex")


}
\references{
Friedrich, S., and Pauly, M. (2018). MATS: Inference for potentially singular and 
  heteroscedastic MANOVA. Journal of Multivariate Analysis, 165, 166-179.
}
