% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/surv_append_matrix.R
\name{surv_append_matrix}
\alias{surv_append_matrix}
\title{Append Survival Test Outputs}
\usage{
surv_append_matrix(work_dir, out_name = "surv_matrix.csv", out_dir = NULL)
}
\arguments{
\item{work_dir}{the directory where the output files of analyze_OrthoMCL are located}

\item{out_name}{file name of outputted matrix}

\item{out_dir}{the directory where the outputted matrix is placed}
}
\value{
A csv file containing a matrix with the following columns: OG, p-values, Bonferroni corrected p-values, mean phenotype of OG-containing taxa, mean pheotype of OG-lacking taxa, taxa included in OG, taxa not included in OG
}
\description{
Function used to append all .csv files that are outputted from analyze_OrthoMCL into one matrix.
}
\examples{

# Not run ~ directory structure depends on system
\dontrun{
file <- system.file('extdata', 'outputs', package='MAGNAMWAR')
directory <- paste(file, '/', sep = '')
surv_append_matrix(directory)
}

}
