% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/structure_RLum.R
\name{structure_RLum}
\alias{structure_RLum}
\alias{structure_RLum,list-method}
\title{General structure function for RLum S4 class objects}
\usage{
structure_RLum(object, ...)

\S4method{structure_RLum}{list}(object, ...)
}
\arguments{
\item{object}{\linkS4class{RLum} (\strong{required}):
S4 object of class \code{RLum}}

\item{...}{further arguments that one might want to pass to the specific
structure method}
}
\value{
Returns a \link{data.frame} with structure of the object.
}
\description{
Function calls object-specific get functions for RLum S4 class objects.
}
\details{
The function provides a generalised access point for specific
\linkS4class{RLum} objects.\cr
Depending on the input object, the corresponding structure function will
be selected. Allowed arguments can be found in the documentations of the
corresponding \linkS4class{RLum} class.
}
\section{Functions}{
\itemize{
\item \code{structure_RLum,list-method}: Returns a list of \linkS4class{RLum} objects that had been passed to \link{structure_RLum}
}}

\section{Function version}{
 0.2.0
}

\examples{

##load example data
data(ExampleData.XSYG, envir = environment())

##show structure
structure_RLum(OSL.SARMeasurement$Sequence.Object)

}
\seealso{
\linkS4class{RLum.Data.Curve}, \linkS4class{RLum.Data.Image},
\linkS4class{RLum.Data.Spectrum}, \linkS4class{RLum.Analysis}, \linkS4class{RLum.Results}
}
\author{
Sebastian Kreutzer, IRAMAT-CRP2A, Université Bordeaux Montaigne (France)
, RLum Developer Team} 

\section{How to cite}{
Kreutzer, S., 2019. structure_RLum(): General structure function for RLum S4 class objects. Function version 0.2.0. In: Kreutzer, S., Burow, C., Dietze, M., Fuchs, M.C., Schmidt, C., Fischer, M., Friedrich, J., 2019. Luminescence: Comprehensive Luminescence Dating Data Analysis. R package version 0.9.6. https://CRAN.R-project.org/package=Luminescence
}

\keyword{utilities}
