% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/length_RLum.R
\name{length_RLum}
\alias{length_RLum}
\title{General accessor function for RLum S4 class objects}
\usage{
length_RLum(object)
}
\arguments{
\item{object}{\linkS4class{RLum} (\strong{required}):
S4 object of class \code{RLum}}
}
\value{
Return is the same as input objects as provided in the list.
}
\description{
Function calls object-specific get functions for RLum S4 class objects.
}
\details{
The function provides a generalised access point for specific
\linkS4class{RLum} objects.\cr
Depending on the input object, the corresponding get function will be selected.
Allowed arguments can be found in the documentations of the corresponding
\linkS4class{RLum} class.
}
\section{Function version}{
 0.1.0
}

\seealso{
\linkS4class{RLum.Data.Curve},
\linkS4class{RLum.Data.Image},
\linkS4class{RLum.Data.Spectrum},
\linkS4class{RLum.Analysis},
\linkS4class{RLum.Results}
}
\author{
Sebastian Kreutzer, Geography & Earth Sciences, Aberystwyth University (United Kingdom)
(France)
, RLum Developer Team} 

\section{How to cite}{
Kreutzer, S., 2021. length_RLum(): General accessor function for RLum S4 class objects. Function version 0.1.0. In: Kreutzer, S., Burow, C., Dietze, M., Fuchs, M.C., Schmidt, C., Fischer, M., Friedrich, J., Mercier, N., Philippe, A., Riedesel, S., Autzen, M., Mittelstrass, D., Gray, H.J., 2021. Luminescence: Comprehensive Luminescence Dating Data Analysis. R package version 0.9.15. https://CRAN.R-project.org/package=Luminescence
}

\keyword{utilities}
