% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_RLum.R
\name{plot_RLum}
\alias{plot_RLum}
\title{General plot function for RLum S4 class objects}
\usage{
plot_RLum(object, ...)
}
\arguments{
\item{object}{\code{\linkS4class{RLum}} (\bold{required}): S4 object of
class \code{RLum}. Optional a \code{\link{list}} containing objects of class \code{\linkS4class{RLum}}
can be provided. In this case the function tries to plot every object in this list according
to its \code{RLum} class.}

\item{\dots}{further arguments and graphical parameters that will be passed
to the specific plot functions. The only argument that is supported directly is \code{main}
(setting the plot title). In contrast to the normal behaviour \code{main} can be here provided as
\code{\link{list}} and the arguments in the list will dispatched to the plots if the \code{object}
is of type \code{list} as well.}
}
\value{
Returns a plot.
}
\description{
Function calls object specific plot functions for RLum S4 class objects.
}
\details{
The function provides a generalised access point for plotting specific
\code{\linkS4class{RLum}} objects.\cr Depending on the input object, the
corresponding plot function will be selected.  Allowed arguments can be
found in the documentations of each plot function.  \tabular{lll}{
\bold{object} \tab \tab \bold{corresponding plot function} \cr

\code{\linkS4class{RLum.Data.Curve}} \tab : \tab
\code{\link{plot_RLum.Data.Curve}} \cr
\code{\linkS4class{RLum.Data.Spectrum}} \tab : \tab
\code{\link{plot_RLum.Data.Spectrum}}\cr
\code{\linkS4class{RLum.Data.Image}} \tab : \tab
\code{\link{plot_RLum.Data.Image}}\cr \code{\linkS4class{RLum.Analysis}}
\tab : \tab \code{\link{plot_RLum.Analysis}}\cr
\code{\linkS4class{RLum.Results}} \tab : \tab
\code{\link{plot_RLum.Results}} }
}
\note{
The provided plot output depends on the input object.
}
\section{Function version}{
 0.4.2 (2016-09-01 11:17:26)
}
\examples{


#load Example data
data(ExampleData.CW_OSL_Curve, envir = environment())

#transform data.frame to RLum.Data.Curve object
temp <- as(ExampleData.CW_OSL_Curve, "RLum.Data.Curve")

#plot RLum object
plot_RLum(temp)


}
\author{
Sebastian Kreutzer, IRAMAT-CRP2A, Universite Bordeaux Montaigne
(France)
\cr R Luminescence Package Team}
\references{
#
}
\seealso{
\code{\link{plot_RLum.Data.Curve}},
\code{\linkS4class{RLum.Data.Curve}}, \code{\link{plot_RLum.Data.Spectrum}},
\code{\linkS4class{RLum.Data.Spectrum}}, \code{\link{plot_RLum.Data.Image}},
\code{\linkS4class{RLum.Data.Image}}, \code{\link{plot_RLum.Analysis}},
\code{\linkS4class{RLum.Analysis}}, \code{\link{plot_RLum.Results}},
\code{\linkS4class{RLum.Results}}
}
\keyword{dplot}

