% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LR-confint.R
\name{confint.LR}
\alias{confint.LR}
\title{Confidence intervals for the Lorenz Regression}
\usage{
\method{confint}{LR}(
  object,
  parm = c("Gini", "LR2", "theta"),
  level = 0.95,
  boot.method = c("Param", "Basic", "Perc"),
  ...
)
}
\arguments{
\item{object}{Output of a call to \code{\link{Lorenz.Reg}}, where \code{penalty="none"} and \code{Boot.inference=TRUE}.}

\item{parm}{Determines whether the confidence interval is computed for the explained Gini coefficient, for the Lorenz-R2 or for the vector of theta coefficients. Possible values are "Gini" (default, for the explained Gini),"LR2" (for the Lorenz-R2) and "theta" (for the vector theta).}

\item{level}{level of the confidence interval}

\item{boot.method}{What bootstrap method is used to construct the confidence interval. Default value is "Param", which exploits the asymptotic normality and only bootstraps the variance.
Other possible values are "Perc" (percentile bootstrap) and "Basic" (basic bootstrap). Percentile bootstrap directly plugs the quantiles of the bootstrap distribution.
Basic bootstrap is based on bootstrapping the whole distribution of the estimator.}

\item{...}{Additional arguments.}
}
\value{
The desired confidence interval. If parm is set to either "Gini" or "LR2", the output is a vector. If parm is set to "theta", it is a matrix where each row corresponds to a different coefficient.
}
\description{
\code{confint.LR} provides confidence intervals for the explained Gini coefficient, Lorenz-R2 and theta vector for an object of class \code{LR}.
}
\details{
Use this function only if Boot.inference was set to TRUE in the call to \code{\link{Lorenz.Reg}}. Otherwise, bootstrap was not computed and the confidence intervals cannot be determined.
}
\examples{
\donttest{
# The following piece of code might take several minutes
data(Data.Incomes)
set.seed(123)
Data <- Data.Incomes[sample(1:nrow(Data.Incomes),50),]
NPLR <- Lorenz.Reg(Income ~ ., data = Data, penalty = "none",
                   seed.boot = 123, B = 40, Boot.inference = TRUE)
confint(NPLR)
}

}
\seealso{
\code{\link{Lorenz.Reg}}
}
