% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ELW_est.R
\name{ELW2S}
\alias{ELW2S}
\title{Two-Step Exact local Whittle estimator of fractional integration with 
unknown mean and time trend.}
\usage{
ELW2S(data, m, trend_order = 0, taper = c("Velasco", "HC"))
}
\arguments{
\item{data}{data vector of length T.}

\item{m}{bandwith parameter specifying the number of Fourier frequencies.
used for the estimation usually \code{floor(1+T^delta)}, where 0<delta<1.}

\item{trend_order}{specifies the form of detrending: 0 for a constant, only, 
1 for a linear trend, and so on.}

\item{taper}{string from \code{c("Velasco","HC")} specifying the tapered form of the local Whittle estimator used in the first step.}
}
\description{
\code{ELW2S} implements the two-step ELW estimator of 
Shimotsu (2010) that is consistent and asymptotically normal in the range from -1/2 to 2.
}
\examples{
library(fracdiff)
T<-1000
d<-0.8
trend<-(1:T)/T
series<-cumsum(fracdiff.sim(T,d=(d-1))$series)
ts.plot(series)
ELW2S(series, m=floor(1+T^0.7), trend_order=0)$d
series2<-series+2*trend
ELW2S(series2, m=floor(1+T^0.7), trend_order=1)$d
series3<-series+2*trend+2*trend^2
ELW2S(series3, m=floor(1+T^0.7), trend_order=2)$d
}
\references{
Shimotsu, K. (2010): Exact Local Whittle
Estimation Of Fractional Integration with Unknown Mean and Time Trend. Econometric Theory,
 Vol. 26, pp. 501 - 540.
}
\author{
Christian Leschinski
}
