% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/local_taxa_tool.R
\name{local_taxa_tool}
\alias{local_taxa_tool}
\title{Perform Geographically-Conscious Taxonomic Assignment}
\usage{
local_taxa_tool(
  path_to_sequences_to_classify,
  path_to_BLAST_database,
  path_to_output_file,
  path_to_list_of_local_taxa = NA,
  include_missing = FALSE,
  blast_e_value = 1e-05,
  blast_max_target_seqs = 2000,
  blast_task = "megablast",
  full_names = FALSE,
  underscores = FALSE,
  separator = ", ",
  blastn_command = "blastn"
)
}
\arguments{
\item{path_to_sequences_to_classify}{String specifying path to FASTA file containing sequences to classify. File path cannot contain spaces.}

\item{path_to_BLAST_database}{String specifying path to BLAST reference database in FASTA format. File path cannot contain spaces.}

\item{path_to_output_file}{String specifying path to output file of classified sequences in CSV format.}

\item{path_to_list_of_local_taxa}{String specifying path to list of local species in CSV format. The file should contain the following fields: 'Common_Name', 'Domain', 'Phylum', 'Class', 'Order', 'Family', 'Genus', 'Species'. There should be no 'NA's or blanks in the taxonomy fields. The species field should contain the binomial name without subspecies or other information below the species level. There should be no duplicate species (\emph{i.e.}, multiple records with the same species binomial and taxonomy) in the local species list. If local taxa suggestions are not desired, set this variable to \code{NA} (the default).}

\item{include_missing}{Logical. If \code{TRUE}, then additional fields are included in the output CSV file in which local sister taxonomic groups without reference sequences are added to the local taxa suggestions. If \code{FALSE} (the default), then this is not performed.}

\item{blast_e_value}{Numeric. Maximum E-value of returned BLAST hits (lower E-values are associated with more 'significant' matches). The default is \code{1e-05}.}

\item{blast_max_target_seqs}{Numeric. Maximum number of BLAST target sequences returned per query sequence. Enough target sequences should be returned to ensure that all minimum E-value matches are returned for each query sequence. A warning will be produced if this value is not sufficient. The default is \code{2000}.}

\item{blast_task}{String specifying BLAST task specification. Use \code{'megablast'} (the default) to find very similar sequences (\emph{e.g.}, intraspecies or closely related species). Use \code{'blastn-short'} for sequences shorter than 50 bases. See the blastn program help documentation for additional options and details.}

\item{full_names}{Logical. If \code{TRUE}, then full taxonomies are returned in the output CSV file. If \code{FALSE} (the default), then only the lowest taxonomic levels (\emph{e.g.}, species binomials instead of the full species taxonomies) are returned in the output CSV file.}

\item{underscores}{Logical. If \code{TRUE}, then taxa names in the output CSV file use underscores instead of spaces. If \code{FALSE} (the default), then taxa names in the output CSV file use spaces.}

\item{separator}{String specifying the separator to use between taxa names in the output CSV file. The default is \code{', '}.}

\item{blastn_command}{String specifying path to the blastn program. The default (\code{'blastn'}) should work for standard BLAST installations. The user can provide a path to the blastn program for non-standard BLAST installations.}
}
\value{
No return value. Writes an output CSV file with fields defined in the details section.
}
\description{
Performs taxonomic assignment of DNA metabarcoding sequences while considering geographic location.
}
\details{
Sequences are BLASTed against a global reference database, and the tool suggests locally occurring species which are most closely related (by taxonomy) to any of the best-matching BLAST hits (by bit score). Optionally, local sister taxonomic groups without reference sequences can be added to the local taxa suggestions by setting the \code{include_missing} argument to \code{TRUE}. If a local taxa list is not provided, then local taxa suggestions will be disabled, but all best-matching BLAST hits will still be returned. Alternatively, a reference database containing just the sequences of local species can be used, and local taxa suggestions can be disabled to return all best BLAST matches of local species. The reference database should be formatted with the \code{\link[=format_reference_database]{format_reference_database}} function, and the local taxa lists can be prepared using the \code{\link[=get_taxonomies.species_binomials]{get_taxonomies.species_binomials}} and \code{\link[=get_taxonomies.IUCN]{get_taxonomies.IUCN}} functions. Output field definitions are:
\itemize{
\item Sequence_name: The query sequence name.
\item Sequence: The query sequence.
\item Best_match_references: Species binomials of all best-matching BLAST hits (by bit score) from the reference database.
\item Best_match_E_value: The E-value associated with the best-matching BLAST hits.
\item Best_match_bit_score: The bit score associated with the best-matching BLAST hits.
\item Best_match_query_cover.mean: The mean query cover of all best-matching BLAST hits.
\item Best_match_query_cover.SD: The standard deviation of query cover of all best-matching BLAST hits.
\item Best_match_PID.mean: The mean percent identity of all best-matching BLAST hits.
\item Best_match_PID.SD: The standard deviation of percent identity of all best-matching BLAST hits.
\item Local_taxa (Field only present if a path to a local taxa list is provided): The finest taxonomic unit(s) which include both any species of the best-matching BLAST hits and any local species. If the species of any of the best-matching BLAST hits are local, then the finest taxonomic unit(s) are at the species level.
\item Local_species (Field only present if a path to a local taxa list is provided): Species binomials of all local species which belong to the taxonomic unit(s) in the Local_taxa field.
\item Local_taxa.include_missing (Field only present if both a path to a local taxa list is provided and the \code{include_missing} argument is set to \code{TRUE}): Local sister taxonomic groups without reference sequences are added to the local taxa suggestions from the Local_taxa field.
\item Local_species.include_missing (Field only present if both a path to a local taxa list is provided and \code{include_missing} argument is set to \code{TRUE}): Species binomials of all local species which belong to the taxonomic unit(s) in the Local_taxa.include_missing field.
}
}
\examples{
\dontshow{if (blast_command_found(blast_command="blastn")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Get path to example query sequences FASTA file.
path_to_query_sequences<-system.file("extdata",
                                     "example_query_sequences.fasta",
                                     package="LocaTT",
                                     mustWork=TRUE)

# Get path to example reference database FASTA file.
path_to_reference_database<-system.file("extdata",
                                        "example_blast_database.fasta",
                                        package="LocaTT",
                                        mustWork=TRUE)

# Get path to example local taxa list CSV file.
path_to_local_taxa_list<-system.file("extdata",
                                     "example_local_taxa_list.csv",
                                     package="LocaTT",
                                     mustWork=TRUE)

# Create a temporary file path for the output CSV file.
path_to_output_CSV_file<-tempfile(fileext=".csv")

# Run the local taxa tool.
local_taxa_tool(path_to_sequences_to_classify=path_to_query_sequences,
                path_to_BLAST_database=path_to_reference_database,
                path_to_output_file=path_to_output_CSV_file,
                path_to_list_of_local_taxa=path_to_local_taxa_list,
                include_missing=TRUE,
                full_names=TRUE,
                underscores=TRUE)
\dontshow{\}) # examplesIf}
}
\references{
A manuscript describing this taxonomic assignment method is in preparation.
}
