% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/organizeResults.R
\name{organizeResults}
\alias{organizeResults}
\title{Prepare output for LipidMS annotation functions}
\usage{
organizeResults(candidates, clfrags, classConf, chainsComb, intrules,
  intConf, nchains, class)
}
\arguments{
\item{candidates}{candidates data frame. Output of \link{findCandidates}.}

\item{clfrags}{vector containing the expected fragments for a given lipid
class.}

\item{classConf}{output of \link{checkClass}}

\item{chainsComb}{output of \link{combineChains}}

\item{intrules}{character vector specifying the fragments to compare. See
\link{checkIntensityRules}.}

\item{intConf}{output of \link{checkIntensityRules}}

\item{nchains}{number of chains of the targeted lipid class.}

\item{class}{character value. Lipid class (i.e. PC, PE, DG, TG, etc.).}
}
\description{
Prepare a readable output for LipidMS identification functions.
}
\examples{
\donttest{
library(LipidMSdata)
dbs <- assignDB()

candidates <- findCandidates(MS1 = MS1_neg$peaklist,
db = dbs$pgdb, ppm = 10, rt = c(0, 2000), adducts = c("M-H"),
rttol = 10, rawData = MS1_neg$rawScans, coelCutoff = 0.8)

MSMS <- rbind(MSMS1_neg$peaklist, MSMS2_neg$peaklist)
rawData <- rbind(MS1_neg$rawScans, MSMS1_neg$rawScans, MSMS2_neg$rawScans)
coelfrags <- coelutingFrags(candidates$RT, MSMS, rttol = 10, rawData = rawData,
coelCutoff = 0.8)

classConf <- checkClass(candidates, coelfrags,
clfrags = c(227.0326, 209.022, 74.0359), clrequisites = c(F, F, F, F),
ftype = c("F", "F", "NL"), ppm = 10, dbs = dbs)

sn1 <- chainFrags(coelfrags, chainfrags = c("lysopg_M-H"), ppm = 10,
dbs = dbs)
sn2 <- chainFrags(coelfrags, chainfrags = c("fa_M-H"), ppm = 10, dbs = dbs)

chainsComb <- combineChains(candidates, nchains=2, sn1, sn2)

intConf <- checkIntensityRules(intrules = c("lysopg_sn1/lysopg_sn1"),
rates = c("2/1"), intrequired = c(T), nchains=2, chainsComb, sn1, sn2)

res <- organizeResults(candidates, clfrags = c(227.0326, 209.022, 74.0359),
classConf, chainsComb, intrules = c("lysopg_sn1/lysopg_sn1"), intConf,
nchains = 2, class="PG")
}


}
\author{
M Isabel Alcoriza-Balaguer <maialba@alumni.uv.es>
}
