% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/idLPEneg.R
\name{idLPEneg}
\alias{idLPEneg}
\title{Lysophosphoethanolamines (LPE) annotation for ESI-}
\usage{
idLPEneg(MS1, MSMS1, MSMS2 = data.frame(), ppm_precursor = 5,
  ppm_products = 10, rttol = 3, rt = c(min(MS1$RT), max(MS1$RT)),
  adducts = c("M-H"), clfrags = c(140.0115, 196.038, 214.048,
  "lysope_M-CH3"), clrequired = c(F, F, F, "excluding"), ftype = c("F", "F",
  "F", "BB"), chainfrags_sn1 = c("fa_M-H"), dbs = list(lysopedb =
  LipidMS::lysopedb, fadb = LipidMS::fadb, adductsTable =
  LipidMS::adductsTable))
}
\arguments{
\item{MS1}{data frame cointaining all peaks from the full MS function. It
must have three columns: m.z, RT (in seconds) and int (intensity).}

\item{MSMS1}{data frame cointaining all peaks from the low energy function.
It must have three columns: m.z, RT and int.}

\item{MSMS2}{data frame cointaining all peaks from the high energy
function if it is the case. It must have three columns: m.z, RT and int.
Optional.}

\item{ppm_precursor}{mass tolerance for precursor ions. By default, 5 ppm.}

\item{ppm_products}{mass tolerance for product ions. By default, 10 ppm.}

\item{rttol}{total rt window for coelution between precursor and product
ions. By default, 3 seconds.}

\item{rt}{rt range where the function will look for candidates. By default,
it will search within all RT range in MS1.}

\item{adducts}{expected adducts for LPE in ESI-. Adducts allowed can
be modified in adductsTable (dbs argument).}

\item{clfrags}{vector containing the expected fragments for a given lipid
class. See \link{checkClass} for details.}

\item{clrequired}{logical vector indicating if each class fragment is
required or not. If any of them is required, at least one of them must be
present within the coeluting fragments. See \link{checkClass} for details.}

\item{ftype}{character vector indicating the type of fragments in clfrags.
It can be: "F" (fragment), "NL" (neutral loss) or "BB" (building block).
See \link{checkClass} for details.}

\item{chainfrags_sn1}{character vector containing the fragmentation rules for
the chain fragments. See \link{chainFrags} for details.}

\item{dbs}{list of data bases required for annotation. By default, dbs
contains the required data frames based on the default fragmentation rules.
If these rules are modified, dbs may need to be changed. If data bases have
been customized using \link{createLipidDB}, they also have to be modified
here.}
}
\value{
List with LPE annotations (results) and some additional information
(class fragments and chain fragments).
}
\description{
LPE identification based on fragmentation patterns for LC-MS/MS
AIF data acquired in negative mode.
}
\details{
\code{idLPEneg} function involves 3 steps. 1) FullMS-based
identification of candidate LPE as M-H. 2) Search of
LPE class fragments: 140.0115, 196.038 and 214.048 coeluting with the
precursor ion. If a loss of CH3 group is found coeluting with any candidate,
this will be excluded as it is a characteristic fragment of LPC.3) Search of
specific fragments that confirm chain composition (FA as M-H).

Results data frame shows: ID, class of lipid, CDB (total number
of carbons and double bounds), FA composition (specific chains composition if
it has been confirmed), mz, RT (in seconds), I (intensity, which comes
directly from de input), Adducts, ppm (m.z error), confidenceLevel (in this
case, as LPE only have one chain, only Subclass and FA level are possible).
}
\note{
Isotopes should be removed before identification to avoid false
positives.
This function has been writen based on fragmentation patterns observed for
two different platforms (QTOF 6550 from Agilent and Sinapt G2-Si from Waters),
but it may need to be customized for other platforms or acquisition settings.
}
\examples{
idLPEneg(MS1 = LipidMS::mix_neg_fullMS, MSMS1 = LipidMS::mix_neg_Ce20,
MSMS2 = LipidMS::mix_neg_Ce40)

idLPEneg(MS1 = LipidMS::serum_neg_fullMS, MSMS1 = LipidMS::serum_neg_Ce20,
MSMS2 = LipidMS::serum_neg_Ce40)

}
\author{
M Isabel Alcoriza-Balaguer <maialba@alumni.uv.es>
}
