% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lmvdencolor.R
\name{lmvdencolor}
\alias{lmvdencolor}
\title{LinkageMapView density color function}
\usage{
lmvdencolor(df, wsize = 30, bias = 5,
  colorin = colorRampPalette(RColorBrewer::brewer.pal(8, "Spectral"))(25))
}
\arguments{
\item{df}{Required, a data frame with the first two columns in this order:
\enumerate{
  \item Linkage group name.
  \item Position - must be in numerical order ascending within
        linkage group name.  If the maximum position in any linkage
        group is < 1000, the density will be calculated
        for each position.  Otherwise the number of positions included
        for each density calculation will be:
        ceiling(maximum position of an linkage group/1000)
}}

\item{wsize}{Optional, default = 30.  # of postions in the sliding window
for calculating postitions/marker. If the maximum position in
any linkage group is >= 1000, the default sliding window size
will be adjusted by the same ratio as the number of positions
included for each density calculate.}

\item{bias}{Optional, default = 5. a positive number. Higher values give
more widely spaced colors at the high end.}

\item{colorin}{Optional, a vector of colors to use where the first value is
the color for the lowest density and the last value is the color
for the highest density.  Default is:
rev(colorRampPalette(RColorBrewer::brewer.pal(8, "Spectral"))(25))}
}
\value{
a data frame that can be used as sectcoldf input on the lmv.linkage.plot
       function to color the chromosome for a density map.
}
\description{
lmvdencolor is a helper function which you can use to create a data frame
of colors to be used as the sectcoldf input parameter on the lmv.linkage.plot command.
The colors will be used to color the linkage group based on the density
of position/marker.This function is called with default values when the
denmap = TRUE parameter is specified for lmv.linkage.plot and no sectcoldf parameter
is found.
}
\examples{

# add a column to a linkage group data frame to specify colors for
# line segments in lmv.linkage.plot using default colors from RColorBrewer
# Spectral palette.  Then just plot the returned colors out to see how
# they look.

data(oat)

sectcoldf <- lmvdencolor(oat)

# see colors produced

image(seq_along(oat[,2]), 1, as.matrix(seq_along(oat[,2])),
 col=sectcoldf$col, axes=FALSE, xlab="", ylab="")
}
\seealso{
\code{\link[grDevices]{colorRamp}}

\code{\link{lmv.linkage.plot}}
}

