% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WLindley.R
\name{WLindley}
\alias{WLindley}
\alias{carbonfibers}
\alias{dwlindley}
\alias{hwlindley}
\alias{pwlindley}
\alias{qwlindley}
\alias{rwlindley}
\title{Weighted Lindley Distribution}
\source{
[d-h-p-q-r]wlindley are calculated directly from the definitions. \code{rwlindley} uses either a two-component mixture of the gamma distributions or the quantile function.
}
\usage{
dwlindley(x, theta, alpha, log = FALSE)

pwlindley(q, theta, alpha, lower.tail = TRUE, log.p = FALSE)

qwlindley(p, theta, alpha, lower.tail = TRUE, log.p = FALSE, L = 1e-04,
  U = 50)

rwlindley(n, theta, alpha, mixture = TRUE, L = 1e-04, U = 50)

hwlindley(x, theta, alpha, log = FALSE)
}
\arguments{
\item{x, q}{vector of positive quantiles.}

\item{theta, alpha}{positive parameters.}

\item{log, log.p}{logical; If TRUE, probabilities p are given as log(p).}

\item{lower.tail}{logical; If TRUE, (default), \eqn{P(X \leq x)} are returned, otherwise \eqn{P(X > x)}.}

\item{p}{vector of probabilities.}

\item{L, U}{interval which \code{uniroot} searches for a root (quantile), L = 1e-4 and U = 50 are the default values.}

\item{n}{number of observations. If \code{length(n) > 1}, the length is taken to be the number required.}

\item{mixture}{logical; If TRUE, (default), random deviates are generated from a two-component mixture of gamma distributions, otherwise from the quantile function.}
}
\value{
\code{dwlindley} gives the density, \code{pwlindley} gives the distribution function, \code{qwlindley} gives the quantile function, \code{rwlindley} generates random deviates and \code{hwlindley} gives the hazard rate function.

Invalid arguments will return an error message.
}
\description{
Density function, distribution function, quantile function, random number generation and hazard rate function for the weighted Lindley distribution with parameters theta and alpha.
}
\details{
Probability density function
\deqn{f( x\mid \theta,\alpha) =\frac{\theta ^{\alpha +1}}{\left( \theta+\alpha \right) \Gamma \left( \alpha \right) }x^{\alpha -1}\left( 1+x\right)e^{-\theta x}  \label{density-weighted-lindley}}

Cumulative distribution function
\deqn{F(x\mid \theta,\alpha) =1 - \frac{\left( \theta +\alpha \right)\Gamma \left( \alpha,\theta x\right) +\left( \theta x\right) ^{\alpha}e^{-\theta x}}{\left( \theta +\alpha \right) \Gamma \left( \alpha \right) }}

Quantile function
\deqn{\code{does not have a closed mathematical expression}}

Hazard rate function
\deqn{h(x\mid \theta,\alpha) =\frac{\theta ^{\alpha +1}x^{\alpha-1}\left( 1+x\right) e^{-\theta x}}{\left( \theta +\alpha \right) \Gamma\left( \alpha,\theta x\right) +\left( \theta x\right) ^{\alpha }e^{-\theta x}}}

where \eqn{\Gamma \left(\alpha,\theta x\right) = \int_{\theta x}^{\infty}x^{\alpha -1}e^{-x}dx} is the upper incomplete gamma function.

\bold{Particular case:} \eqn{\alpha=1} the one-parameter Lindley distribution.
}
\note{
The \code{\link[stats]{uniroot}} function with default arguments is used to find out the quantiles.
}
\examples{
set.seed(1)
x <- rwlindley(n = 1000, theta = 1.5, alpha = 1.5, mixture = TRUE)
R <- range(x)
S <- seq(from = R[1], to = R[2], by = 0.1)
plot(S, dwlindley(S, theta = 1.5, alpha = 1.5), xlab = 'x', ylab = 'pdf')
hist(x, prob = TRUE, main = '', add = TRUE)

p <- seq(from = 0.1, to = 0.9, by = 0.1)
q <- quantile(x, prob = p)
pwlindley(q, theta = 1.5, alpha = 1.5, lower.tail = TRUE)
pwlindley(q, theta = 1.5, alpha = 1.5, lower.tail = FALSE)
qwlindley(p, theta = 1.5, alpha = 1.5, lower.tail = TRUE)
qwlindley(p, theta = 1.5, alpha = 1.5, lower.tail = FALSE)

## carbon fibers data (from Ghitany et al., 2013)
data(carbonfibers)
library(fitdistrplus)
fit <- fitdist(carbonfibers, 'wlindley', start = list(theta = 0.1, alpha = 0.1))
plot(fit)

}
\author{
Josmar Mazucheli \email{jmazucheli@gmail.com}

Larissa B. Fernandes \email{lbf.estatistica@gmail.com}
}
\references{
Al-Mutairi, D. K., Ghitany, M. E., Kundu, D., (2015). Inferences on stress-strength reliability from weighted Lindley distributions. \emph{Communications in Statistics - Theory and Methods}, \bold{44}, (19), 4096-4113.

Bashir, S., Rasul, M., (2015). Some properties of the weighted Lindley distribution. \emph{EPRA Internation Journal of Economic and Business Review}, \bold{3}, (8), 11-17.

Ghitany, M. E., Alqallaf, F., Al-Mutairi, D. K. and Husain, H. A., (2011). A two-parameter weighted Lindley distribution and its applications to survival data. \emph{Mathematics and Computers in Simulation}, \bold{81}, (6), 1190-1201.

Mazucheli, J., Louzada, F., Ghitany, M. E., (2013). Comparison of estimation methods for the parameters of the weighted Lindley distribution. \emph{Applied Mathematics and Computation}, \bold{220}, 463-471.

Mazucheli, J., Coelho-Barros, E. A. and Achcar, J. (2016). An alternative reparametrization on the weighted Lindley distribution. \emph{Pesquisa Operacional}, (to appear).
}
\seealso{
\code{\link[lamW]{lambertWm1}}, \code{\link[stats]{uniroot}}, \code{\link[LindleyR]{DWLindley}}.
}

