% Generated by roxygen2 (4.0.2.9000): do not edit by hand
% Please edit documentation in R/class_calib.R
\name{class.calib}
\alias{class.calib}
\title{Classical Linear Calibration Function}
\usage{
class.calib(x, y, alpha, y0)
}
\arguments{
\item{x}{numerical vector of regressor measurments}

\item{y}{numerical vector of observation measurements}

\item{alpha}{the confidence interval to be calculated}

\item{y0}{vector of observed calibration value}
}
\description{
\code{class.calib} uses the classical frequentist approach to estimate an unknown X given observed vector y0 and calculates confidence interval estimates.
}
\examples{
X <- c(1,1,2,2,3,3,4,4,5,5,6,6,7,7,8,8,9,9,10,10)
Y <- c(1.8,1.6,3.1,2.6,3.6,3.4,4.9,4.2,6.0,5.9,6.8,6.9,8.2,7.3,8.8,8.5,9.5,9.5,10.6,10.6)

class.calib(X,Y,0.05,6)
}
\references{
Eisenhart, C. (1939). The interpretation of certain regression methods and their use in biological and industrial research. Annals of Mathematical Statistics. 10, 162-186.
}
\keyword{calibration}
\keyword{linear}

