% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/symlog_trans.R
\name{symlog_trans}
\alias{symlog_trans}
\title{Scale positive and negative values on a log scale}
\usage{
symlog_trans(base = 10, thr = 1, scale = 1)
}
\arguments{
\item{base}{Base for the logarithmic transformation. The default is 10.}

\item{thr}{Threshold after which a logarithmic transformation is applied. If the absolute value is below this \code{threshold}, the value is not transformed. The default is 1.}

\item{scale}{Scaling factor for logarithmically transformed values above the \code{threshold}. The default is 1.}
}
\value{
a transformation function that can be used in \pkg{ggplot2} or \pkg{plotly} to scale positive and negative values on a log scale.
}
\description{
To create a plot with positive and negative (unscaled) values on a log-transformed axis, the values need to be scaled accordingly. R or \pkg{ggplot2} do not have a built-in function for this, but the following function can be used to create a transformation function for this purpose. The function was coded based on a \href{https://stackoverflow.com/a/14674703}{post on stack overflow}. The \code{symlog} transformation is the standard transformation used e.g., in \code{\link[=gg_day]{gg_day()}}.
}
\details{
The \code{symlog} transformation can be accessed either via the \code{trans = "symlog"} argument in a scaling function, or via \code{trans = symlog_trans()}. The latter allows setting the individual arguments.
}
\examples{
dataset <- 
sample.data.environment \%>\%
filter_Date(end = "2023-08-29") \%>\% 
dplyr::mutate(MEDI = dplyr::case_when(
                                     Id == "Environment" ~ -MEDI,
                                     .default = MEDI))
#basic application where transformation, breaks and labels are set manually
dataset \%>\%                                     
gg_day(aes_col = Id) +
ggplot2::scale_y_continuous(
trans = "symlog")

#the same plot, but with breaks and labels set manually                            
dataset \%>\%                                     
gg_day(aes_col = Id) +
ggplot2::scale_y_continuous(
trans = "symlog", 
breaks = c(-10^(5:0), 0, 10^(0:5)),
labels = function(x) format(x, scientific = FALSE, big.mark = " "))

#setting individual arguments of the symlog function manually allows
#e.g., to emphasize values smaller than 1
dataset \%>\%                                     
gg_day(aes_col = Id) +
ggplot2::scale_y_continuous(
trans = symlog_trans(thr = 0.01),
breaks = c(-10^(5:-1), 0, 10^(-1:5)),
labels = function(x) format(x, scientific = FALSE, big.mark = " "))

}
\references{
This function`s code is a straight copy from a post on \href{https://stackoverflow.com/a/14674703}{stack overflow}.
The author of the answer is \href{https://stackoverflow.com/users/1320535/julius-vainora}{Julius Vainora}, and the author of the question \href{https://stackoverflow.com/users/1212562/brian-b}{Brian B}
}
