% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LexisNexisTools.R
\name{lnt_convert}
\alias{lnt_convert}
\alias{lnt2df}
\alias{lnt2rDNA}
\alias{lnt2quanteda}
\alias{lnt2tm}
\alias{lnt2cptools}
\alias{lnt2tidy}
\alias{lnt2SQLite}
\title{Convert LNToutput to other formats}
\usage{
lnt_convert(
  x,
  to = "data.frame",
  what = "articles",
  collapse = FALSE,
  file = "LNT.sqlite",
  ...
)

lnt2df(x, what = "articles", ...)

lnt2rDNA(x, what = "articles", collapse = TRUE)

lnt2quanteda(x, what = "articles", collapse = NULL, ...)

lnt2tm(x, what = "articles", collapse = NULL, ...)

lnt2cptools(x, what = "articles", ...)

lnt2tidy(x, what = "articles", ...)

lnt2SQLite(x, file = "LNT.sqlite", ...)
}
\arguments{
\item{x}{An object of class LNToutput.}

\item{to}{Which format to convert into. Possible values are "rDNA",
"corpustools", "tidytext", "tm", "SQLite" and "quanteda".}

\item{what}{Either "articles" or "paragraphs" to use articles or paragraphs as
text in the output object.}

\item{collapse}{Only has an effect when \code{what = "articles"}. If set to
TRUE, an empty line will be added after each paragraphs. Alternatively you
can enter a custom string (such as \code{"\\n"} for newline). \code{NULL}
or \code{FALSE} turns off this feature.}

\item{file}{The name of the database to be written to (for lnt2SQLite only).}

\item{...}{Passed on to different methods (see details).}
}
\description{
Takes output from \link{lnt_read} and converts it to other formats. You can
either use \code{lnt_convert()} and choose the output format via \code{to} or
use the individual functions directly.
}
\details{
lnt_convert() provides conversion methods into several formats
commonly used in prominent R packages for text analysis. Besides the
options set here, the ... (ellipsis) is passed on to the individual methods
for tuning the outcome:
\itemize{
\item data.frame, rDNA ... not used.
\item quanteda ... passed on to \code{\link[quanteda:corpus]{quanteda::corpus()}}.
\item corpustools ... passed on to \code{\link[corpustools:create_tcorpus]{corpustools::create_tcorpus()}}.
\item tm ... passed on to \code{\link[tm:Corpus]{tm::Corpus()}}.
\item tidytext ... passed on to \code{\link[tidytext:unnest_tokens]{tidytext::unnest_tokens()}}.
\item lnt2SQLite ... passed on to \code{\link[RSQLite:dbWriteTable]{RSQLite::dbWriteTable()}}.
}
}
\examples{
LNToutput <- lnt_read(lnt_sample(copy = FALSE))

df <- lnt_convert(LNToutput, to = "data.frame")

docs <- lnt_convert(LNToutput, to = "rDNA")

corpus <- lnt_convert(LNToutput, to = "quanteda")

\dontrun{

tCorpus <- lnt_convert(LNToutput, to = "corpustools")

tidy <- lnt_convert(LNToutput, to = "tidytext")

Corpus <- lnt_convert(LNToutput, to = "tm")

dbloc <- lnt_convert(LNToutput, to = "SQLite")
}

}
