% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loadImageArea.R
\name{startweb.area}
\alias{startweb.area}
\title{Opens default web browser and loads a web page for area estimation.}
\usage{
startweb.area()
}
\description{
Function \code{startweb.area()} opens a web browser and loads the page
for area estimation of object shown in a picture. Use this function if you
can isolate a part of the picture with uniformly distributed dots on an
elliptical domain with unclear borders. Sequence of actions on the web page
is as follows:
\enumerate{
 \item Load a picture in JPG format
 \item Click on upper left and lower right corner of a rectangle surrounding
  observed object so the rectangle is drawn
 \item Set data and estimation parameters
 \item Click on Estimate
 }
}
\details{
The area estimation algorithm takes many horizontal and vertical (if
"horizontal + vertical" slicing is selected) or star-shaped (if "star"
slicing is selected) slices of the object. Length estimation procedure is
conducted on each slice and in that way set of edge points is obtained.
Lastly, ellipse or circle is fitted on that set of points by function
\code{\link[conicfit]{EllipseDirectFit}} or
\code{\link[conicfit]{CircleFitByPratt}} from the package \code{conicfit}
and area of that ellipse or circle is returned as the result. The area is
measured in pixels, as well as percentage of the whole image.

Parameters that can be set on the web page are as follows:

\strong{Data parameters}
 \describe{
   \item{Levels of grey}{Number of colors (shades of grey) used in
     analysis.}
   \item{Box size}{The algorithm takes each pixel of a picture and maps it
     to box_size * box_size matrix. It is done in a way that the brightness
     of the observed pixel dictates the quantity of dots in mentioned
     matrix. Distribution of dots in matrix is uniform. Ultimately, length
     estimation is done on the set of the resulting matrices.}
   \item{Line thickness}{Width of the slice, i.e. the maximum length between
     surrounding pixel and the drawn line so that pixel is to be taken into
     account for length estimation. All surrounding pixels are orthogonally
     projected on the central line.}
   \item{Number of slices}{Number of slices after cutting in one direction.
     Defaults to 10. Slices are equally thick in both directions. Smaller
     number of cuts will be automatically applied for smaller dimension if
     the chosen rectangle is not a square.}
   \item{Slicing}{Sets slicing method for the edge point estimation. Can be
     "horizontal + vertical" or "star".}
   \item{Parallelization}{Sets whether to distribute area estimation on
     multiple CPU cores. If set to On, total number of cores - 1 are used.}
   \item{Object brightness}{Sets whether observed object is bright or
     dark.}
   \item{Represent object as}{Represent estimated object as an ellipse or as
     a circle.}
 }
 \strong{Estimation parameters}
 \describe{
   \item{Error distribution}{Type of the error distribution. Can be Gauss,
     Laplace or Student.}
   \item{Error standard deviation}{Estimation method for the error
     standard deviation. Can be Maximum Likelihood (ML) or the Method of
     Moments. If one does not want to estimate the deviation but to
     explicitly enter it, he should choose "Enter value" and enter the
     deviation in the lower field.}
 }
}
\section{Note}{

In order to have quadratic pixels on the screen, please use proportional
screen resolution. In the case of modern LCD (LED) displays, these are
usually native screen resolutions. If your display has aspect ratio
width:height = 16:9, these resolutions are 1280x720, 1600x900, 1920x1080,
etc. In the case od 16:10 display, use 1280x800, 1440x900, 1920x1200, etc.
If you use nonproportional screen resolution, pixels on the screen will not
be quadratic, so estimated values measured in pixels may not be correct.
}

\examples{
# open the web page for area estimation of an object shown in the picture
\donttest{startweb.area()}

}
