\name{pLambertW}
\alias{pLambertW}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{Cumulative Distribution Function}
\description{
Cumulative distribution function (cdf) for Lambert W RV.
}
\usage{
pLambertW(y, theta = c(0, 0, 1), distname = "normal")
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{y}{ value }
  \item{theta}{ parameter vector }
  \item{distname}{ input distribution }
}

\value{
Value of the cdf at y.
}
\references{Goerg, G.M. (2009). \dQuote{Lambert W Random Variables - A new class of skewed distribution functions}. Unpublished}
\author{Georg M. Goerg}

\examples{
theta.s=c(0.1,0,1)

aux.lambert=function(y){
pLambertW(y, theta=theta.s)
}

support(theta.s)

plot(aux.lambert, -3.5,3.5, ylab="Probability")
plot(pnorm, -3.5,3.5, add=TRUE, lty=2)
legend("topleft" , c("Lambert W - Gaussian" , "Gaussian"), lty=1:2)
}

% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{univar}
