% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_gaps_fbhs.R
\name{get_plots_gap_fbh}
\alias{get_plots_gap_fbh}
\title{Plots of tree profiles with gaps and fuel layers base height (fbh)}
\usage{
get_plots_gap_fbh (LAD_profiles,depth_metrics)
}
\arguments{
\item{LAD_profiles}{original tree Leaf Area Density (LAD) profile (output of [lad.profile()] function in the \emph{leafR} package.
An object of the class text}

\item{depth_metrics}{tree metrics with gaps (distances), fuel base heights and depths (output of [get_depths()] function).
An object of the class text}
}
\value{
A plot drawing by lines the height of gaps and fuel layers bases in tiff format.
}
\description{
This function plots gaps and fuel layers base height (fbh) in the vertical tree profile (VTP).
}
\examples{
library(ggplot2)
library(dplyr)

# LAD profiles derived from normalized ALS data after applying [lad.profile()] function
LAD_profiles <- read.table(system.file("extdata", "LAD_profiles.txt", package = "LadderFuelsR"),
header = TRUE)
LAD_profiles$treeID <- factor(LAD_profiles$treeID)

# Before running this example, make sure to run get_depths().
if (interactive()) {
depth_metrics <- get_depths()
LadderFuelsR::depth_metrics$treeID <- factor(LadderFuelsR::depth_metrics$treeID)

# Generate plots for gaps and fbhs
plots_gaps_fbhs <- get_plots_gap_fbh(LAD_profiles, depth_metrics)
}
}
\seealso{
\code{\link{get_depths}}
}
\author{
Olga Viedma, Carlos Silva and JM Moreno
}
