% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_matrix_functions.R
\name{trigBasisExp}
\alias{trigBasisExp}
\title{Compute the design matrix for a trigonometric basis expansion}
\usage{
trigBasisExp(tod, L = 24, degree = 1)
}
\arguments{
\item{tod}{equidistant sequence of a cyclic variable

For time of day and e.g. half-hourly data, this could be 1, ..., L and L = 48, or 0.5, 1, 1.5, ..., 24 and L = 24.}

\item{L}{length of one cycle on the scale of the time variable. For time of day, this would be 24.}

\item{degree}{degree K of the trigonometric link above. Increasing K increases the flexibility.}
}
\value{
design matrix (without intercept column), ordered as sin1, cos1, sin2, cos2, ...
}
\description{
Given a periodically varying variable such as time of day or day of year and the associated cycle length, this function performs a basis expansion to efficiently calculate a linear predictor of the form
\deqn{ 
 \eta^{(t)} = \beta_0 + \sum_{k=1}^K \bigl( \beta_{1k} \sin(\frac{2 \pi k t}{L}) + \beta_{2k} \cos(\frac{2 \pi k t}{L}) \bigr). 
 }
 This is relevant for modeling e.g. diurnal variation and the flexibility can be increased by adding smaller frequencies (i.e. increasing \eqn{K}).
}
\examples{
## hourly data
tod = rep(1:24, 10)
Z = trigBasisExp(tod, L = 24, degree = 2)

## half-hourly data
tod = rep(1:48/2, 10) # in [0,24] -> L = 24
Z1 = trigBasisExp(tod, L = 24, degree = 3)

tod = rep(1:48, 10) # in [1,48] -> L = 48
Z2 = trigBasisExp(tod, L = 48, degree = 3)

all(Z1 == Z2)
# The latter two are equivalent specifications!
}
