% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Helper_Functions.R
\name{tnorm_mixture_conditional}
\alias{tnorm_mixture_conditional}
\title{Title: Calculates mean and variance of mixture of two truncated normal distributions}
\usage{
tnorm_mixture_conditional(mu, var, lower, upper, K_i, K_pop)
}
\arguments{
\item{mu}{Mean value of normal distribution.}

\item{var}{Variance of normal distribution.}

\item{lower}{Lower threshold (can be -Inf).}

\item{upper}{Upper threshold (can be Inf).}

\item{K_i}{(Stratified) cumulative incidence proportion for the individual.}

\item{K_pop}{Population prevalence (cumulative incidence proportion).}
}
\value{
mean and variance of mixture distribution between two truncated normal distributions
}
\description{
Title: Calculates mean and variance of mixture of two truncated normal distributions
}
\examples{
tnorm_mixture_conditional(mu = 0, var = 1, lower = -Inf, upper = Inf, K_i = 0, K_pop = 0.01)
tnorm_mixture_conditional(mu = 0, var = 1, lower = -Inf, upper = 2, K_i = .01, K_pop = 0.05)
}
