% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LNRT.R
\name{LNRT}
\alias{LNRT}
\title{Log-normal response time modelling}
\usage{
LNRT(RT, data, XG = 1000, Discrimination = TRUE, WL = FALSE)
}
\arguments{
\item{RT}{a Person-x-Item matrix of log-response times (time spent on solving an item).}

\item{data}{either a list or a simLNIRT object containing the response time matrix. 
If a simLNIRT object is provided, in the summary the simulated time parameters are shown alongside of the estimates.
If the RT variable cannot be found in the list, or if no data object is given, then the RT variable is taken
from the environment from which LNRT is called.}

\item{XG}{the number of MCMC iterations to perform (default: 1000).}

\item{Discrimination}{estimate the time-discrimination parameter (default: true).}

\item{WL}{define the time-discrimination parameter as measurement error variance parameter (default: false).}
}
\value{
an object of class LNRT.
}
\description{
Log-normal response time modelling
}
\examples{
# Log-normal response time modelling
data <- simLNIRT(N = 500, K = 20, rho = 0.8, WL = FALSE)
summary(LNRT(RT = RT, data = data, XG = 500, Discrimination = TRUE, WL = FALSE))
 
}
