\name{Linp}
\alias{Linp}
\alias{Linp.lim}
\alias{Linp.limfile}
\alias{Linp.character}
\alias{Linp.double}
\title{Solves a linear inverse model using linear programming}
\description{Solves a linear inverse model using linear programming
  \cr Input presented either:
  \item matrices E, F, A, B, G, H (Linp.double) or
  \item as a list (Linp.lim) or
  \item as a lim input file (Linp.limfile)
  }
\usage{
Linp(...)
Linp.lim(lim,cost=NULL,ispos=lim$ispos,...)
Linp.limfile(file, verbose=TRUE,...)
Linp.character(...)
Linp.double(...) }
\arguments{
  \item{lim }{a list that contains the linear programming specification, as  generated by function \code{Setup}}
  \item{file }{name of the linear inverse input file}
  \item{verbose }{if TRUE: when reading the file, prints warnings and messages to the screen}
  \item{cost }{if not NULL, a vector with the coefficients of the cost function (to be minimised)}
  \item{ispos }{if TRUE: all x-values have to be positive}
  \item{... }{other arguments passed to function \\code{\link[limSolve]{linp}} from package\code{limSolve}}
}
\value{
  a list containing:
  \item{X }{vector containing the solution of the linear programming problem.}
  \item{unconstrained.solution }{vector containing the unconstrained solution of the linear programming problem}
  \item{residualNorm }{scalar, the sum of residuals of equalities and violated inequalities}
  \item{solutionNorm }{scalar, the value of the quadratic function at the solution}
  \item{IsError }{logical, TRUE if an error occurred}
  \item{Error }{linp error text}
  \item{type }{linp}
}
\author{Karline Soetaert <k.soetaert@nioo.knaw.nl>}
\references{Michel Berkelaar and others (2005). lpSolve: Interface to Lpsolve v. 5 
   to solve linear/integer programs. R package version 1.1.9.}
\details{Solves the following inverse problem:
 \deqn{\min(\sum {Cost_i*x_i})} or 
 \deqn{\max(\sum {Profit_i*x_i})} subject to        
 \deqn{x_i>=0}
 \deqn{Ax=B}
 \deqn{Gx>=H}
 \cr and where \eqn{Cost_i} or \eqn{Profit_i} are weighting coefficients

}
 
\examples{
  # the Blending example
  Linp(LIMBlending)

  # the E coli example: two functions to maximimise
  Linp(LIMEcoli)
  # E coli example, but only first function optimised..
  Linp(LIMEcoli,cost=-LIMEcoli$Profit[1,])

  # a foodweb example: need to specify the cost function
  # here just sum of absolute values of flows...
  Linp(LIMRigaAutumn,cost=(rep(1,LIMRigaAutumn$NUnknowns)))
  }

\seealso{\code{\link[lpSolve]{linp}}, the more general function from package lpSolve
\item \code{\link{Ldei}}, to solve the linear inverse problem by least distance programming 
\item \code{\link{Lsei}}, to solve the linear inverse problem by lsei (least squares with equality and inequality constraints)
\item function \code{\link[limSolve]{linp}} from package\code{limSolve}
}
\keyword{algebra}
\keyword{array}
\keyword{optimize}

