% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SNPclip.R
\name{SNPclip}
\alias{SNPclip}
\title{Query SNPclip API}
\usage{
SNPclip(snps, pop = "CEU", r2_threshold = "0.1",
  maf_threshold = "0.01", token = NULL, file = FALSE)
}
\arguments{
\item{snps}{a list of between 1 - 5,000 variants, using an rsID or chromosome coordinate (e.g. "chr7:24966446")}

\item{pop}{a 1000 Genomes Project population, (e.g. YRI or CEU), multiple allowed, default = "CEU"}

\item{r2_threshold}{LD R2 threshold between 0-1, default = 0.1}

\item{maf_threshold}{minor allele frequency threshold between 0-1, default = 0.01}

\item{token}{LDlink provided user token, default = NULL, register for token at \url{https://ldlink.nci.nih.gov/?tab=apiaccess}}

\item{file}{Optional character string naming a path and file for saving results.  If file = FALSE, no file will be generated, default = FALSE.}
}
\value{
a data frame
}
\description{
Query SNPclip API
}
\examples{
\dontrun{SNPclip(c("rs3", "rs4", "rs148890987"), "YRI", "0.1", "0.01",
                    token = Sys.getenv("LDLINK_TOKEN"))
                 }

}
