% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ldaGSVD.R
\name{predict.ldaGSVD}
\alias{predict.ldaGSVD}
\title{Predictions from a fitted ldaGSVD object}
\usage{
\method{predict}{ldaGSVD}(object, newdata, type = c("response", "prob"), ...)
}
\arguments{
\item{object}{a fitted model object of class \code{ldaGSVD}, which is assumed to
be the result of the \code{\link[=ldaGSVD]{ldaGSVD()}} function.}

\item{newdata}{data frame containing the values at which predictions are
required. Missing values are NOT allowed.}

\item{type}{character string denoting the type of predicted value returned.
The default is to return the predicted class (\code{type} = 'response'). The
predicted posterior probabilities for each class will be returned if \code{type}
= 'prob'.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
The function returns different values based on the \code{type}, if
\itemize{
\item \code{type = 'response'}: vector of predicted responses.
\item \code{type = 'prob'}: a data frame of the posterior probabilities. Each class takes a column.
}
}
\description{
Prediction of test data using a fitted ldaGSVD object
}
\details{
Unlike the original paper, which uses the k-nearest neighbor (k-NN) as the
classifier, we use a faster and more straightforward likelihood-based method.
One limitation of the traditional likelihood-based method for LDA is that it
ceases to work when there are Linear Discriminant (LD) directions with zero
variance in the within-class scatter matrix. However, when using LDA/GSVD,
all chosen LD directions possess non-zero variance in the between-class
scatter matrix. This implies that LD directions with zero variance in the
within-class scatter matrix will yield the highest Fisher's ratio. Therefore,
to get these directions higher weights, we manually adjust the zero variance
to \code{1e-15} for computational reasons.
}
\examples{
fit <- ldaGSVD(Species~., data = iris)
predict(fit,iris)
# output prosterior probabilities
predict(fit,iris,type = "prob")
}
\references{
Ye, J., Janardan, R., Park, C. H., & Park, H. (2004). \emph{An
optimization criterion for generalized discriminant analysis on
undersampled problems}. IEEE Transactions on Pattern Analysis and Machine
Intelligence

Howland, P., Jeon, M., & Park, H. (2003). \emph{Structure preserving dimension
reduction for clustered text data based on the generalized singular value
decomposition}. SIAM Journal on Matrix Analysis and Applications
}
