% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pcirm.R
\name{pcirm}
\alias{pcirm}
\title{Partially Confirmatory Item Response Model}
\usage{
pcirm(
  dat,
  Q,
  LD = TRUE,
  cati = NULL,
  PPMC = FALSE,
  burn = 5000,
  iter = 5000,
  update = 1000,
  missing = NA,
  rseed = 12345,
  digits = 4,
  alas = FALSE,
  verbose = FALSE
)
}
\arguments{
\item{dat}{A \eqn{N \times J} data \emph{matrix} or \emph{data.frame} consisting of the
responses of \eqn{N} individuals to \eqn{J} items. Only continuous and dichotomous data are supported.}

\item{Q}{A \eqn{J \times K} design matrix for the loading pattern with \eqn{K} factors and \eqn{J} items.
Elements are 1, -1, and 0 for specified, unspecified, and zero-fixed loadings, respectively. For models with
LI or the E-step, one can specify a few (e.g., 2) loadings per factor. For models with LD or the C-step, the
sufficient condition of one specified loading per item is suggested, although there can be a few items
without any specified loading. See \code{Examples}.}

\item{LD}{logical; \code{TRUE} for allowing LD (model with LD or C-step).}

\item{cati}{The set of dichotomous items in sequence number (i.e., 1 to \eqn{J});
\code{NULL} for no and -1 for all items (default is \code{NULL}).}

\item{PPMC}{logical; \code{TRUE} for conducting posterior predictive model checking.}

\item{burn}{Number of burn-in iterations before posterior sampling.}

\item{iter}{Number of formal iterations for posterior sampling (> 0).}

\item{update}{Number of iterations to update the sampling information.}

\item{missing}{Value for missing data (default is \code{NA}).}

\item{rseed}{An integer for the random seed.}

\item{digits}{Number of significant digits to print when printing numeric values.}

\item{alas}{logical; for adaptive Lasso or not. The default is \code{FALSE}.}

\item{verbose}{logical; to display the sampling information every \code{update} or not.

\itemize{
    \item \code{Feigen}: Eigenvalue for each factor.
    \item \code{NLA_le3}: Number of Loading estimates >= .3 for each factor.
    \item \code{Shrink}: Shrinkage (or ave. shrinkage for each factor for adaptive Lasso).
    \item \code{sign_sw}: Number of sign switch.
    \item \code{Adj PSR}: Adjusted PSR for each factor.
    \item \code{Ave. Int.}: Ave. item intercept.
    \item \code{LD>.2 >.1 LD>.2 >.1}: # of LD terms larger than .2 and .1, and LD's shrinkage parameter.
}}
}
\value{
\code{pcirm} returns an object of class \code{lawbl} with item intercepts. It contains a lot of information about
the posteriors that can be summarized using \code{\link{summary.lawbl}}.
}
\description{
\code{pcirm} is a partially confirmatory approach to item response models (Chen, 2020),
which estimates the intercept for continuous and dichotomous data. Similar to PCFA and GPCFA,
 there are two major model variants with different constraints for identification. One assumes local
 independence (LI) with a more exploratory tendency, which can be also called the E-step.
 The other allows local dependence (LD) with a more confirmatory tendency, which can be also
 called the C-step. Parameters are obtained by sampling from the posterior distributions with
 the Markov chain Monte Carlo (MCMC) techniques. Different Bayesian Lasso methods are used to
 regularize the loading pattern and LD. The estimation results can be summarized with \code{\link{summary.lawbl}}
 and the factorial eigenvalue can be plotted with \code{\link{plot_lawbl}}.
}
\examples{
\donttest{
####################################
#  Example 1: Estimation with LD   #
####################################

dat <- sim24ccfa21$dat
J <- ncol(dat)
K <- 3
Q<-matrix(-1,J,K);
Q[1:8,1]<-Q[9:16,2]<-Q[17:24,3]<-1

m0 <- pcirm(dat = dat, Q = Q, LD = TRUE, cati = -1, burn = 2000,iter = 2000)
summary(m0) # summarize basic information
summary(m0, what = 'qlambda') #summarize significant loadings in pattern/Q-matrix format
summary(m0, what = 'offpsx') #summarize significant LD terms

####################################
#  Example 2: Estimation with LD   #
####################################

Q<-cbind(Q,-1);
Q[15:16,4]<-1

m1 <- pcirm(dat = dat, Q = Q, LD = FALSE, cati = -1, burn = 2000,iter = 2000)
summary(m1) # summarize basic information
summary(m1, what = 'qlambda') #summarize significant loadings in pattern/Q-matrix format
summary(m1, what = 'offpsx') #summarize significant LD terms
}
}
\references{
Chen, J. (2020). A partially confirmatory approach to the multidimensional item response theory with the Bayesian Lasso.
\emph{Psychometrika}. 85(3), 738-774. DOI:10.1007/s11336-020-09724-3.
}
