% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_eigen.R
\name{plot_eigen}
\alias{plot_eigen}
\title{Factorial eigenvalue plot}
\usage{
plot_eigen(obj, what = "trace")
}
\arguments{
\item{obj}{A \code{lawbl} object}

\item{what}{A list of options for what to plot.

\itemize{
     \item \code{trace}: The trace of each factor's eigenvalue.
    \item \code{density}: The trace of each factor's eigenvalue.
    \item \code{APSR}: The pseudo Gelman-Rubin diagnostics of each factor's eigenvalue.
 }}
}
\description{
Provide plots based on the factorial eigenvalues of a \code{pcfa} objects.
}
\examples{
\donttest{
dat <- sim18cfa0$dat
J <- ncol(dat)
K <- 3
Q<-matrix(-1,J,K);
Q[1:2,1]<-Q[7:8,2]<-Q[13:14,3]<-1


m0 <- pcfa(dat = dat, Q = Q, LD = FALSE,burn = 1000, iter = 1000)
plot_eigen(m0) # trace
plot_eigen(m0, what='density')
plot_eigen(m0, what='APSR')
}
}
