% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coordinates.R
\name{coordinatize}
\alias{coordinatize}
\title{Convert a LAGOSNE flat file into a spatial object}
\usage{
coordinatize(dt, latname = "nhd_lat", longname = "nhd_long", crs = 4326)
}
\arguments{
\item{dt}{data.frame}

\item{latname}{character name of latitude column; default is "nhd_lat"}

\item{longname}{character name of longitude column; default is "nhd_long"}

\item{crs}{numeric epsg code; default is 4326 WGS84-lat-long}
}
\description{
This function turns a data.frame into a spatial object using a reasonable
 default projection.
}
\examples{
\dontrun{
dt <- lagosne_load("1.087.3")
res <- coordinatize(dt$locus)

library(maps)
map("state", xlim = c(-97.90363, -66.99892), ylim = c(34.61761, 49.41941))
plot(res$geometry, add = TRUE, pch = 19, cex = 0.05)
}
}
