/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.kr.tagging;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.lucene.analysis.kr.morph.AnalysisOutput;
import org.apache.lucene.analysis.kr.morph.MorphException;
import org.apache.lucene.analysis.kr.utils.ConstraintUtil;
import org.apache.lucene.analysis.kr.utils.FileUtil;
import org.apache.lucene.analysis.kr.utils.KoreanEnv;
import org.apache.lucene.analysis.kr.utils.StringUtil;
import org.apache.lucene.analysis.kr.utils.Trie;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Tagger {
    private static Trie<String, String[]> occurrences;
    private static final String tagDicLoc = "tagger.dic";
    private static final String NILL = "NILL";
    private static final String NOPATN = "0";
    private AnalysisOutput po;

    public AnalysisOutput tagging(String psource, List<AnalysisOutput> pmorphs) throws MorphException {
        return this.tagging(psource, null, pmorphs, null);
    }

    public AnalysisOutput tagging(String psource, String rsource, List<AnalysisOutput> pmorphs, List<AnalysisOutput> rmorphs) throws MorphException {
        if (!(pmorphs != null && pmorphs.size() != 0 || rmorphs != null && rmorphs.size() != 0)) {
            return null;
        }
        this.po = this.lookupBest(psource, rsource, pmorphs, rmorphs);
        this.po.setSource(psource);
        return this.po;
    }

    private AnalysisOutput lookupBest(String psource, String rsource, List<AnalysisOutput> pmorphs, List<AnalysisOutput> rmorphs) throws MorphException {
        if (pmorphs.size() == 1) {
            return pmorphs.get(0);
        }
        AnalysisOutput select = null;
        if (rmorphs != null && rmorphs.size() != 0) {
            select = this.lookupBestByRWord(psource, rsource, pmorphs, rmorphs);
        }
        if (select != null) {
            return select;
        }
        if (this.po != null) {
            select = this.lookupBestByPWord(psource, pmorphs);
        }
        if (select != null) {
            return select;
        }
        return pmorphs.get(0);
    }

    private AnalysisOutput lookupBestByPWord(String rsource, List<AnalysisOutput> rmorphs) throws MorphException {
        ArrayList removes = new ArrayList();
        for (AnalysisOutput morph : rmorphs) {
            Iterator<String[]> iterw = Tagger.getGR("F" + rsource + "^W");
            AnalysisOutput best = this.selectBest(iterw, this.po.getSource(), rsource, this.po, morph, true, removes);
            if (best != null) {
                return best;
            }
            Iterator<String[]> iters = Tagger.getGR("F" + morph.getStem() + "^S");
            best = this.selectBest(iters, this.po.getSource(), rsource, this.po, morph, true, removes);
            if (best == null) continue;
            return best;
        }
        for (AnalysisOutput morph : removes) {
            if (rmorphs.size() <= 1) continue;
            rmorphs.remove(morph);
        }
        return null;
    }

    private AnalysisOutput lookupBestByRWord(String psource, String rsource, List<AnalysisOutput> pmorphs, List<AnalysisOutput> rmorphs) throws MorphException {
        ArrayList removes = new ArrayList();
        for (AnalysisOutput rmorph : rmorphs) {
            if (rmorph.getScore() != 100) break;
            String rend = rmorph.getJosa();
            if (rend == null) {
                rend = rmorph.getEomi();
            }
            for (AnalysisOutput pmorph : pmorphs) {
                AnalysisOutput best;
                Iterator<String[]> iterw = Tagger.getGR("R" + psource + "^W/");
                String pend = pmorph.getJosa();
                if (pend == null) {
                    pend = pmorph.getEomi();
                }
                if ((best = this.selectBest(iterw, psource, rsource, pmorph, rmorph, false, removes)) != null) {
                    return best;
                }
                Iterator<String[]> iters = Tagger.getGR("RNILL/" + pend + "/");
                best = this.selectBest(iters, psource, rsource, pmorph, rmorph, false, removes);
                if (best != null) {
                    return best;
                }
                iters = Tagger.getGR("R" + pmorph.getStem() + "^S/");
                best = this.selectBest(iters, psource, rsource, pmorph, rmorph, false, removes);
                if (best == null) continue;
                return best;
            }
        }
        for (AnalysisOutput morph : removes) {
            if (pmorphs.size() <= 1) continue;
            pmorphs.remove(morph);
        }
        return null;
    }

    private AnalysisOutput selectBest(Iterator<String[]> iter, String psource, String rsource, AnalysisOutput pmorph, AnalysisOutput rmorph, boolean rear, List removes) {
        while (iter.hasNext()) {
            String[] values = iter.next();
            if (this.checkGrammer(values, psource, rsource, pmorph, rmorph, rear)) {
                if (rear) {
                    return rmorph;
                }
                return pmorph;
            }
            if (!"1".equals(values[6])) continue;
            if (removes.contains(pmorph)) break;
            removes.add(pmorph);
            break;
        }
        return null;
    }

    private boolean checkGrammer(String[] values, String psource, String rsource, AnalysisOutput pmorph, AnalysisOutput rmorph, boolean depFront) {
        String rend;
        boolean ok = true;
        String pend = pmorph.getJosa();
        if (pend == null) {
            pend = pmorph.getEomi();
        }
        if ((rend = rmorph.getJosa()) == null) {
            rend = rmorph.getEomi();
        }
        if (depFront && !NILL.equals(values[0]) && !this.checkWord(psource, values[0], pmorph)) {
            return false;
        }
        if (!NILL.equals(values[1]) && !this.checkEomi(values[1], pend)) {
            return false;
        }
        if (!NOPATN.equals(values[2]) && !this.checkPattern(values[2], pmorph.getPatn())) {
            return false;
        }
        if (!(depFront || NILL.equals(values[3]) || this.checkWord(rsource, values[3], rmorph))) {
            return false;
        }
        if (!NILL.equals(values[4]) && !this.checkEomi(values[4], rend)) {
            return false;
        }
        return NOPATN.equals(values[5]) || this.checkPattern(values[5], rmorph.getPatn());
    }

    private boolean checkWord(String source, String value, AnalysisOutput morph) {
        String[] types = StringUtil.split(value, "^");
        String[] strs = StringUtil.split(types[0], ",");
        String text = source;
        if ("S".equals(types[1])) {
            text = morph.getStem();
        }
        int i = 0;
        while (i < strs.length) {
            if (strs[i].equals(text)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean checkEomi(String value, String rend) {
        String[] strs = StringUtil.split(value, ",");
        int i = 0;
        while (i < strs.length) {
            if (strs[i].equals(rend)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean checkPattern(String value, int ptn) {
        String[] strs = StringUtil.split(value, ",");
        String strPtn = Integer.toString(ptn);
        int i = 0;
        while (i < strs.length) {
            if ("E".equals(strs[i]) && ConstraintUtil.isEomiPhrase(ptn)) {
                return true;
            }
            if ("J".equals(strs[i]) && (ConstraintUtil.isJosaNounPhrase(ptn) || ptn == 1)) {
                return true;
            }
            if (strs[i].equals(strPtn)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static synchronized Iterator<String[]> getGR(String prefix) throws MorphException {
        if (occurrences == null) {
            Tagger.loadTaggerDic();
        }
        return occurrences.getPrefixedBy(prefix);
    }

    private static synchronized void loadTaggerDic() throws MorphException {
        occurrences = new Trie(true);
        try {
            List strs = FileUtil.readLines(KoreanEnv.getInstance().getValue(tagDicLoc), "UTF-8");
            for (String str : strs) {
                String[] syls;
                if (str == null || (syls = StringUtil.split(str = str.trim(), ":")).length != 4) continue;
                String key = null;
                key = "F".equals(syls[0]) ? String.valueOf(syls[2].substring(0, syls[2].lastIndexOf("/") + 1)) + syls[1].substring(0, syls[1].lastIndexOf("/")) : String.valueOf(syls[1].substring(0, syls[1].lastIndexOf("/") + 1)) + syls[2].substring(0, syls[2].lastIndexOf("/"));
                String[] patns = StringUtil.split(String.valueOf(syls[1]) + "/" + syls[2] + "/" + syls[3], "/");
                occurrences.add(String.valueOf(syls[0]) + key, patns);
            }
        }
        catch (Exception e) {
            throw new MorphException("Fail to read the tagger dictionary.(tagger.dic)\n" + e.getMessage());
        }
    }
}

