% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/power_lm.R
\name{power_lm}
\alias{power_lm}
\title{Compute the post-hoc power and/or plan the sample size for one or a set of predictors in linear regression}
\usage{
power_lm(PRE = 0.02, PC = 0, PA = 1, power = 0.8, sig.level = 0.05, n = NULL)
}
\arguments{
\item{PRE}{Proportional Reduction in Error.
\emph{PRE} = The square of partial correlation.
Cohen (1988) suggested >=0.02, >=0.13, and >=0.26 as cut-off values of PRE for small,
medium, and large effect sizes, respectively.}

\item{PC}{Number of parameters of model C (compact model) without focal predictors of interest.}

\item{PA}{Number of parameters of model A (augmented model) with focal predictors of interest.}

\item{power}{Expected statistical power for effects of focal predictors.}

\item{sig.level}{Expected significance level for effects of focal predictors.}

\item{n}{The current sample size. If \emph{n} is given, the post-hoc power would be computed.}
}
\value{
A list with 4 items: (1) \code{post}, the post-hoc F-test, lambda (non-centrality parameter),
and power for sample size \emph{n};
(2)\code{minimum}, the minimum sample size required for focal predictors to reach the
expected statistical power and significance level;
(3) \code{prior}, a data.frame including \code{n_i}, \code{PC}, \code{PA},\code{df_A_i}, \code{F_i}, \code{p_i}, \code{lambda_i}, \code{power_i}.
\verb{_i} indicates these statistics are the intermediate iterative results.
Each row of \code{prior} presents results for one possible sample size \code{n_i}.
Given \code{n_i}, \code{df_A_i}, \code{F_i}, \code{p_i}, \code{lambda_i} and \code{power_i} would be computed accordingly.
(4) A plot of power against sample size \emph{n}.
The cut-off value of \emph{n} for expected statistical power \code{power} and
expected significance level \code{sig.level} is annotated on the plot.
}
\description{
Compute the post-hoc power and/or plan the sample size for one or a set of predictors in linear regression
}
\examples{
power_lm()
}
\references{
Cohen, J. (1988). \emph{Statistical power analysis for the behavioral sciences} (2nd ed.). Routledge.
}
